/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.anyuri.length.length_2;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class length2_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        length2_GetSetCTTests test = new length2_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    JAXBElement<String> elemObj;

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "length-2-1.xml", "length-2-2.xml", "length-2-3.xml",
            "length-2-4.xml", "length-2-5.xml"
        };
        String [] initialValues = {
            "ftp://ftp.securityfordisseminateusestoperva.edu/",
            "mailto:applicationsbusi@personalandtheXMLfor.gov",
            "ftp://availableandtopervasivetheNISTSunsyst.org/",
            "ftp://ftp.matchandofverticaltestingNSRLandc.edu/",
            "http://requestingoftestingmeasurementtheane.edu/"
        };
        String [] setValues = {
            "ftp://ftp.foo.foo/fo/foo/foo/foo/foo/foo/foo/foo",
            "foo.foo/fo/foo/foo/foo/foo/foo/foo/foo/foo/fooo/",
            "ftp://ftp.securityfordisseminateusestoperva.edu/",
            "mailto:applicationsbusi@personalandtheXMLfor.gov",
            "ftp://availableandtopervasivetheNISTSunsyst.org/",
        };
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<String> elemObj = (JAXBElement<String>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(initialValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + initialValues[i]);
            }
            elemObj.setValue(setValues[i]);
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + setValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + setValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        String [] initialValues = {
            "ftp://ftp.securityfordisseminateusestoperva.edu",
            "mailto:applicationsbusi@personalandtheXMLfor.gov",
            "ftp://availableandtopervasivetheNISTSunsyst.org",
            "ftp://ftp.matchandofverticaltestingNSRLandc.edu",
            "http://requestingoftestingmeasurementtheane.edu"
        };
        String [] setValues = {
            "ftp://ftp.foo.foo/fo/foo/foo/foo/foo/foo/foo-oo",
            "foo.foo/fo/foo/foo/foo/foo/foo/foo/foo/foo/fooo",
            "ftp://ftp.securityfordisseminateusestoperva.edu",
            "mailto:applicationsbusi@personalandtheXMLfor.gov",
            "ftp://availableandtopervasivetheNISTSunsyst.org",
        };
        for (int i = 0; i < initialValues.length; ++i){
            
                elemObj = (JAXBElement<String>)(new ObjectFactory()).createNISTSchemaAnyURILength2(initialValues[i]);
            
            if (!elemObj.getValue().equals(initialValues[i])){
                return Status.failed("dynamically created JAXBElement<String>, elemObj.getValue() != " + initialValues[i]);
            }
            elemObj.setValue(setValues[i]);
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<String>, elemObj.setValue(" + setValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + setValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

