/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.DataElement;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.TSEISException;
import com.sun.ts.tests.common.connector.whitebox.TSResourceManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class TSeis {
    private static TSeis eis;
    private Hashtable permtable = new Hashtable();
    private boolean commitflag = true;
    private TSConnectionImpl con1 = null;
    private TSConnectionImpl con2 = null;
    private TSConnectionImpl con3 = null;
    private TSConnectionImpl con4 = null;
    private TSConnectionImpl con5 = null;
    private Vector conset = null;
    public TSResourceManager rm = new TSResourceManager();

    private TSeis() {
        this.conset = new Vector();
        this.con1 = new TSConnectionImpl();
        this.con2 = new TSConnectionImpl();
        this.con3 = new TSConnectionImpl();
        this.con4 = new TSConnectionImpl();
        this.con5 = new TSConnectionImpl();
        this.conset.addElement(this.con1);
        this.conset.addElement(this.con2);
        this.conset.addElement(this.con3);
        this.conset.addElement(this.con4);
        this.conset.addElement(this.con5);
    }

    public static TSeis getTSeis() {
        if (eis == null) {
            eis = new TSeis();
        }
        return eis;
    }

    public synchronized TSConnection getConnection() {
        TSConnectionImpl con;
        ConnectorStatus.getConnectorStatus().logAPI("TSeis.getConnection", "", "");
        for (int i = 0; i < this.conset.size(); ++i) {
            con = (TSConnectionImpl)this.conset.elementAt(i);
            if (!con.lease()) continue;
            return con;
        }
        con = new TSConnectionImpl();
        con.lease();
        this.conset.addElement(con);
        return con;
    }

    public synchronized TSConnection getConnection(String usr, char[] passwd) {
        ConnectorStatus.getConnectorStatus().logAPI("TSeis.getConnection", "usr,passwd", "");
        System.out.println("User is " + usr);
        if (usr.equals("cts1") && passwd[0] == 'c' && passwd[1] == 't' && passwd[2] == 's' && passwd[3] == '1' || usr.equals("cts2") && passwd[0] == 'c' && passwd[1] == 't' && passwd[2] == 's' && passwd[3] == '2') {
            System.out.println("Passwd length is " + passwd.length);
            for (int in = 0; in < passwd.length; ++in) {
                System.out.println("Password 3 is " + passwd[in]);
            }
            for (int i = 0; i < this.conset.size(); ++i) {
                TSConnectionImpl con = (TSConnectionImpl)this.conset.elementAt(i);
                if (!con.lease()) continue;
                return con;
            }
            TSConnectionImpl con = new TSConnectionImpl();
            con.lease();
            this.conset.addElement(con);
            return con;
        }
        System.out.println("Connection null returned, wrong user or password");
        return null;
    }

    public DataElement read(String key, TSConnection con) throws TSEISException {
        DataElement de = null;
        if (this.permtable.containsKey(key)) {
            de = (DataElement)this.permtable.get(key);
        }
        DataElement element = this.rm.read(key, con);
        DataElement localElement = null;
        Hashtable tempTable = con.getTempTable();
        if (tempTable.containsKey(key)) {
            localElement = (DataElement)tempTable.get(key);
        }
        if (de == null && element == null && localElement == null) {
            throw new TSEISException("Data not found.");
        }
        if (element != null) {
            return element;
        }
        if (localElement != null) {
            return localElement;
        }
        return de;
    }

    public String readValue(String key, TSConnection con) throws TSEISException {
        DataElement de = this.read(key, con);
        return de.getValue();
    }

    public void insert(String key, String value, TSConnection con) throws TSEISException {
        boolean datapresent = false;
        try {
            this.read(key, con);
            datapresent = true;
        }
        catch (TSEISException tSEISException) {
            // empty catch block
        }
        if (datapresent) {
            throw new TSEISException("Duplicate Key");
        }
        DataElement de = new DataElement(key, value);
        if (this.getResourceManager().getTransactionStatus(con) == 0 && con.getAutoCommit()) {
            de.setStatus(1);
            System.out.println("TSeis.insert.permtable");
            this.permtable.put(key, de);
        } else {
            System.out.println("TSeis.insert.temptable");
            de.setStatus(4);
            con.getTempTable().put(key, de);
        }
    }

    public void update(String key, String value, TSConnection con) throws TSEISException {
        DataElement de = this.read(key, con);
        de.updateVersion();
        de.setValue(value);
        if (this.getResourceManager().getTransactionStatus(con) == 0 && con.getAutoCommit()) {
            de.setStatus(1);
            System.out.println("TSeis.update.permtable");
            this.permtable.put(key, de);
        } else {
            System.out.println("TSeis.update.temptable");
            if (de.getStatus() != 4) {
                de.setStatus(5);
            }
            System.out.println("TSeis.update." + de.getKey() + de.getValue());
            con.getTempTable().put(key, de);
        }
    }

    public void delete(String key, TSConnection con) throws TSEISException {
        DataElement de = this.read(key, con);
        if (this.getResourceManager().getTransactionStatus(con) == 0 && con.getAutoCommit()) {
            System.out.println("TSeis.delete.permtable");
            this.permtable.remove(key);
        } else {
            System.out.println("TSeis.delete.temptable");
            de.setStatus(3);
            con.getTempTable().put(key, de);
        }
    }

    public void returnConnection(TSConnectionImpl con) {
        con.expireLease();
    }

    public void dropTable() {
        ConnectorStatus.getConnectorStatus().logAPI("TSeis.dropTable", "", "");
        this.permtable.clear();
        ConnectorStatus.getConnectorStatus().logAPI("Table Dropped ", "", "");
    }

    public void setAutoCommit(boolean flag) {
        this.commitflag = flag;
    }

    public boolean getAutoCommit() {
        return this.commitflag;
    }

    public Vector readData() {
        System.out.println("TSeis.readData");
        Vector<String> v = new Vector<String>();
        Enumeration e = this.permtable.keys();
        while (e.hasMoreElements()) {
            DataElement de = (DataElement)this.permtable.get((String)e.nextElement());
            System.out.println("TSeis.readData." + de.getValue());
            v.add(de.getValue());
        }
        return v;
    }

    private void copyVector(Vector v1, Vector v2) {
        int size = v1.size();
        v2.clear();
        for (int i = 0; i < size; ++i) {
            String str1 = (String)v1.get(i);
            v2.add(i, new String(str1));
        }
    }

    public void begin() {
        ConnectorStatus.getConnectorStatus().logAPI("TSeis.begin", "", "");
    }

    public void commit(TSConnection con) throws TSEISException {
        Hashtable ht = con.getTempTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            DataElement de = (DataElement)ht.get(key);
            if (de.getStatus() == 4) {
                this.actualInsert(de);
            }
            if (de.getStatus() == 5) {
                this.actualUpdate(de);
            }
            if (de.getStatus() != 3) continue;
            this.actualDelete(de.getKey());
        }
    }

    void actualInsert(DataElement de) throws TSEISException {
        if (this.permtable.containsKey(de.getKey())) {
            throw new TSEISException("Duplicate Key");
        }
        de.setStatus(1);
        this.permtable.put(de.getKey(), de);
    }

    void actualUpdate(DataElement de) throws TSEISException {
        DataElement element = (DataElement)this.permtable.get(de.getKey());
        if (element.getStatus() == 2) {
            throw new TSEISException("Cannot update now. 2PC in progress");
        }
        de.setStatus(1);
        this.permtable.put(de.getKey(), de);
    }

    void actualDelete(String key) throws TSEISException {
        if (this.permtable.containsKey(key)) {
            DataElement element = (DataElement)this.permtable.get(key);
            if (element.getStatus() == 2) {
                throw new TSEISException("Cannot update now. 2PC in progress");
            }
            this.permtable.remove(key);
        }
    }

    void prepareInsert(DataElement de, Xid xid) throws TSEISException {
        if (this.permtable.containsKey(de.getKey())) {
            throw new TSEISException("Duplicate Key");
        }
        DataElement element = new DataElement(de.getKey(), de.getValue());
        element.prepare(de, xid);
        this.permtable.put(element.getKey(), element);
    }

    void prepareChange(DataElement de, Xid xid) throws TSEISException {
        DataElement element = (DataElement)this.permtable.get(de.getKey());
        DataElement prepElement = new DataElement(de.getKey());
        prepElement.prepare(de, xid);
        this.permtable.put(element.getKey(), prepElement);
    }

    public void commit(Xid xid) {
        System.out.println("Tseis.commit.xid");
        Enumeration e = this.permtable.keys();
        while (e.hasMoreElements()) {
            System.out.println("commit.inTheLoop");
            String key = (String)e.nextElement();
            DataElement de = (DataElement)this.permtable.get(key);
            if (de.getStatus() != 2 || de.getXid() != xid) continue;
            DataElement element = de.getPreparedValue();
            if (element.getStatus() == 3) {
                System.out.println("commit.delete");
                this.permtable.remove(element.getKey());
                continue;
            }
            System.out.println("commit.update");
            element.setStatus(1);
            this.permtable.put(element.getKey(), element);
        }
    }

    public void rollback(Xid xid) {
        System.out.println("Tseis.rollback.xid");
        Enumeration e = this.permtable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            DataElement de = (DataElement)this.permtable.get(key);
            if (de.getStatus() != 2 || de.getXid() != xid) continue;
            de.setStatus(1);
            this.permtable.put(de.getKey(), de);
        }
    }

    public TSResourceManager getResourceManager() {
        return this.rm;
    }
}

