/*
 * Copyright (c) 2007, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * @(#)eventClient1.java	1.26 03/05/16
 */

package com.sun.ts.tests.connector.localTx.event;

import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;

public class eventClient1 extends ServiceEETest implements Serializable {

  private TSNamingContext nctx = null;

  private TSConnection con = null;

  private String whitebox_tx = null;

  private String whitebox_tx_param = null;

  private TSDataSource ds1 = null;

  private DBSupport dbutil = null;

  /* Run test in standalone mode */
  public static void main(String[] args) {
    eventClient1 theTests = new eventClient1();
    Status s = theTests.run(args, System.out, System.err);
    s.exit();
  }

  /*
   * @class.setup_props: whitebox-tx, JNDI name of TS WhiteBox;
   *
   * @class.testArgs: -ap tssql.stmt
   *
   */
  public void setup(String[] args, Properties p) throws Exception {

    // Get JNDI lookups for both adapters. The harness will throw if these
    // properties can not be retrieved, so there is no need for error checking
    // here.
    whitebox_tx = p.getProperty("whitebox-tx");
    logMsg("Using: " + whitebox_tx);

    // Construct our DBSupport object. This object performs interactions
    // on a table, based on the properties object supplied.
    try {
      dbutil = new DBSupport();
    } catch (Exception e) {
      throw new Exception(
          "Exception constructing DBSupport object: " + e.getMessage(), e);
    }

    // Obtain a TSDataSource object to interact with our resource adapter.
    try {
      nctx = new TSNamingContext();
      ds1 = (TSDataSource) nctx.lookup(whitebox_tx);
    } catch (Exception e) {
      TestUtil.printStackTrace(e);
      TestUtil.logMsg("Exception during JNDI lookup: " + e.getMessage());
    }
  }

  /*
   * @testName: testConnectionEventListener
   *
   * @assertion_ids: Connector:SPEC:32; Connector:SPEC:35; Connector:SPEC:28;
   * Connector:JAVADOC:155; Connector:JAVADOC:156; Connector:JAVADOC:157;
   * Connector:JAVADOC:158; Connector:JAVADOC:159; Connector:JAVADOC:160;
   * Connector:JAVADOC:152; Connector:JAVADOC:153; Connector:JAVADOC:154;
   *
   * @test_Strategy: Call Con.close and verify CONNECTION_CLOSED event has been
   * sent to the ConnectionEventListener through
   * JdbcConnectionEventListerner.sendEvent.
   */
  public void testConnectionEventListener() throws Exception {
    boolean b = false;
    try {
      con = ds1.getConnection();
      TestUtil.logMsg("Got connection.");
    } catch (Exception sqle) {
      TestUtil.logMsg("Exception caught on creating connection:");
      throw new Exception(sqle.getMessage(), sqle);
    }

    try {
      // Turn logging on for close method; check for CONNECTION_CLOSED
      ds1.setLogFlag(true);
      con.close();
      ds1.setLogFlag(false);

      // Check if the connection event was called.
      String toCheck = "TSConnectionEventListener.sendEvent:CONNECTION_CLOSED:";
      Vector log = ds1.getLog();
      if (log.contains(toCheck)) {
        b = true;
      }

      TestUtil.logTrace(log.toString());

      if (b == true) {
        TestUtil.logMsg("CONNECTION_CLOSED called correctly.");
      } else {
        throw new Exception("CONNECTION_CLOSED event was not called.");
      }

      // Clean up log
      ds1.clearLog();

    } catch (Exception e) {
      TestUtil.logMsg("Exception caught on closing connection:");
      throw new Exception(e.getMessage(), e);
    }

  }

  /* cleanup */
  public void cleanup() throws Exception {
    TestUtil.logMsg("Cleanup");
    try {
      ds1.clearLog();
      TestUtil.logTrace("Closing connection in cleanup.");
      con.close();
    } catch (Exception sqle) {
      TestUtil.logErr("Exception on cleanup: " + sqle.getMessage(), sqle);
    }
  }
}
