/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.xml;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.layout.xml.XMLErrorHandler;
import com.sun.jsftemplating.layout.xml.XMLLayoutDefinitionReader;
import com.sun.jsftemplating.util.ClasspathEntityResolver;
import com.sun.jsftemplating.util.FileUtil;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class XMLLayoutDefinitionManager
extends LayoutDefinitionManager {
    private static final String XLDM_INSTANCE = "__jsft_XML_LDM";
    public static final String ENTITY_RESOLVER = "entityResolver";
    public static final String ERROR_HANDLER = "errorHandler";
    public static final String BASE_URI = "baseURI";

    protected XMLLayoutDefinitionManager() {
        try {
            this.setErrorHandler(new XMLErrorHandler(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "UTF-8"), true)));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.setEntityResolver(new ClasspathEntityResolver());
    }

    public static LayoutDefinitionManager getInstance() {
        return XMLLayoutDefinitionManager.getInstance(FacesContext.getCurrentInstance());
    }

    public static LayoutDefinitionManager getInstance(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        XMLLayoutDefinitionManager instance = null;
        if (ctx != null) {
            instance = (XMLLayoutDefinitionManager)ctx.getExternalContext().getApplicationMap().get(XLDM_INSTANCE);
        }
        if (instance == null) {
            instance = new XMLLayoutDefinitionManager();
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(XLDM_INSTANCE, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accepts(String key) {
        URL url = null;
        try {
            url = FileUtil.searchForFile(key, ".jsf");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (url == null) {
            return false;
        }
        try (TemplateParser parser = new TemplateParser(url);){
            parser.open();
            parser.readUntil("<layoutDefinition>", true);
        }
        return true;
    }

    @Override
    public LayoutDefinition getLayoutDefinition(String key) throws LayoutDefinitionException {
        URL url = null;
        try {
            url = FileUtil.searchForFile(key, ".jsf");
        }
        catch (IOException ex) {
            throw new LayoutDefinitionException("Unable to locate '" + key + "'", ex);
        }
        if (url == null) {
            throw new LayoutDefinitionException("Unable to locate '" + key + "'");
        }
        LayoutDefinition ld = null;
        String baseURI = this.getBaseURI();
        try {
            ld = new XMLLayoutDefinitionReader(url, this.getEntityResolver(), this.getErrorHandler(), baseURI).read();
        }
        catch (IOException ex) {
            throw new LayoutDefinitionException("Unable to process '" + url + "'.  EntityResolver: '" + this.getEntityResolver() + "'.  ErrorHandler: '" + this.getErrorHandler() + "'.  baseURI: '" + baseURI + "'.", ex);
        }
        ld.dispatchInitPageHandlers(FacesContext.getCurrentInstance(), ld);
        return ld;
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)this.getAttribute(ENTITY_RESOLVER);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.setAttribute(ENTITY_RESOLVER, entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.getAttribute(ERROR_HANDLER);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.setAttribute(ERROR_HANDLER, errorHandler);
    }

    public String getBaseURI() {
        String baseURI = (String)this.getAttribute(BASE_URI);
        if (baseURI == null) {
            baseURI = FileUtil.getResource("").toString();
        }
        return baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.setAttribute(BASE_URI, baseURI);
    }
}

