/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import org.glassfish.admin.rest.generator.client.ClientClassWriter;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.jvnet.hk2.config.ConfigModel;

class PythonClientClassWriter
implements ClientClassWriter {
    private final String className;
    private final StringBuilder source;
    private final File packageDir;
    private static String TMPL_CTOR = "from restclientbase import *\n\nclass CLASS(RestClientBase):\n    def __init__(self, connection, parent, name = None):\n        self.name = name\n        RestClientBase.__init__(self, connection, parent, name)\n        self.parent = parent\n        self.connection = connection\n\n    def getRestUrl(self):\n        return self.getParent().getRestUrl() + self.getSegment() + (('/' + self.name) if self.name else '')\n";
    private final String TMPL_GET_SEGMENT = "    def getSegment(self):\n        return '/SEGMENT'\n";
    private static String TMPL_COMMAND_METHOD = "\n    def COMMAND(self PARAMS, optional={}):\nMERGE        return self.execute('/PATH', 'METHOD', optional, MULTIPART)\n";
    private static String TMPL_GETTER_AND_SETTER = "\n    def getMETHOD(self):\n        return self.getValue('FIELD')\n\n    def setMETHOD(self, value):\n        self.setValue('FIELD', value)\n";
    private static String TMPL_GET_CHILD_RESOURCE = "\n    def getELEMENT(self, name):\n        from IMPORT import CHILD\n        child = CHILD(self.connection, self, name)\n        return child if (child.status == 200) else None\n";

    PythonClientClassWriter(ConfigModel model, String className, Class parent, File baseDirectory) {
        boolean success;
        this.className = className;
        this.packageDir = baseDirectory;
        this.packageDir.deleteOnExit();
        boolean bl = success = this.packageDir.exists() || this.packageDir.mkdirs();
        if (!success) {
            throw new RuntimeException("Unable to create output directory");
        }
        this.source = new StringBuilder(TMPL_CTOR.replace("CLASS", className));
    }

    @Override
    public void generateGetSegment(String tagName) {
        this.source.append("    def getSegment(self):\n        return '/SEGMENT'\n".replace("SEGMENT", tagName));
    }

    @Override
    public void generateCommandMethod(String methodName, String httpMethod, String resourcePath, CommandModel cm) {
        String parametersSignature = Util.getMethodParameterList(cm, true, false);
        Boolean needsMultiPart = parametersSignature.contains("java.io.File");
        Object parameters = Util.getMethodParameterList(cm, false, false);
        if (!((String)parameters).isEmpty()) {
            parameters = ", " + (String)parameters;
        }
        StringBuilder merge = new StringBuilder();
        Collection params = cm.getParameters();
        if (params != null && !params.isEmpty()) {
            for (CommandModel.ParamModel model : params) {
                Param param = model.getParam();
                if (param.optional()) continue;
                String key = !param.alias().isEmpty() ? param.alias() : model.getName();
                String paramName = Util.eleminateHypen(model.getName());
                merge.append("        optional['").append(key).append("'] = _").append(paramName).append("\n");
            }
        }
        this.source.append(TMPL_COMMAND_METHOD.replace("COMMAND", methodName).replace("PARAMS", (CharSequence)parameters).replace("MERGE", merge.toString()).replace("PATH", resourcePath).replace("METHOD", httpMethod).replace("MULTIPART", Util.upperCaseFirstLetter(needsMultiPart.toString())));
    }

    @Override
    public String generateMethodBody(CommandModel cm, String httpMethod, String resourcePath, boolean includeOptional, boolean needsMultiPart) {
        return null;
    }

    @Override
    public void generateGettersAndSetters(String type, String methodName, String fieldName) {
        this.source.append(TMPL_GETTER_AND_SETTER.replace("METHOD", methodName).replace("FIELD", fieldName));
    }

    @Override
    public void createGetChildResource(ConfigModel model, String elementName, String childResourceClassName) {
        boolean hasKey = Util.getKeyAttributeName(model) != null;
        String method = TMPL_GET_CHILD_RESOURCE.replace("CHILD", childResourceClassName).replace("IMPORT", childResourceClassName.toLowerCase(Locale.getDefault())).replace("ELEMENT", elementName);
        if (!hasKey) {
            method = method.replace(", name", "");
        }
        this.source.append(method);
    }

    @Override
    public void generateCollectionLeafResourceGetter(String className) {
        this.source.append(TMPL_GET_CHILD_RESOURCE.replace("CHILD", className).replace("IMPORT", className.toLowerCase(Locale.getDefault())).replace("ELEMENT", className).replace(", name", ""));
    }

    @Override
    public void generateRestLeafGetter(String className) {
        this.generateCollectionLeafResourceGetter(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        File classFile = new File(this.packageDir, this.className.toLowerCase(Locale.getDefault()) + ".py");
        BufferedWriter writer = null;
        try {
            try {
                if (!classFile.createNewFile()) {
                    throw new RuntimeException("Unable to create new file");
                }
                classFile.deleteOnExit();
                writer = new BufferedWriter(new FileWriter(classFile, StandardCharsets.UTF_8));
                writer.append(this.source.toString());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

