/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.NamedEventManager;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.NamedEvent;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamedEventConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES = List.of(NamedEvent.class);
    private Map<Class<?>, Annotation> namedEvents;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.namedEvents == null) {
            this.namedEvents = new HashMap();
        }
        this.namedEvents.put(target, annotation);
    }

    @Override
    public void push(FacesContext ctx) {
        ApplicationAssociate associate;
        if (this.namedEvents != null && (associate = ApplicationAssociate.getInstance(ctx.getExternalContext())) != null) {
            NamedEventManager nem = associate.getNamedEventManager();
            for (Map.Entry<Class<?>, Annotation> entry : this.namedEvents.entrySet()) {
                this.process(nem, entry.getKey(), entry.getValue());
            }
        }
    }

    private void process(NamedEventManager nem, Class<?> annotatedClass, Annotation annotation) {
        Object name = annotatedClass.getSimpleName();
        int index = ((String)name).lastIndexOf("Event");
        if (index > -1) {
            name = ((String)name).substring(0, index);
        }
        name = annotatedClass.getPackage().getName() + "." + Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        nem.addNamedEvent((String)name, annotatedClass);
        String shortName = ((NamedEvent)annotation).shortName();
        if (!shortName.isEmpty()) {
            if (nem.isDuplicateNamedEvent(shortName)) {
                nem.addDuplicateName(shortName, annotatedClass);
            } else {
                nem.addNamedEvent(shortName, annotatedClass);
            }
        }
    }
}

