/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.progress.ProgressStatusClient;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.progress.ProgressStatusDTO;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

public class ProgressStatusPrinter
implements AdminCommandEventBroker.AdminCommandListener<GfSseInboundEvent> {
    private static final String CONTENT_TYPE = "application/json";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ProgressStatusPrinter.class);
    private static final char[] spinner = new char[]{'|', '/', '-', '\\'};
    private String lastMessage;
    private int lastMsgLength = 0;
    private boolean firstPrint = true;
    private int spinnerIndex = -1;
    private Ticker ticker = null;
    private ProgressStatusClient client = new ProgressStatusClient(null);
    private CommandProgress commandProgress;
    private final boolean disableAnimation;
    private final boolean debugOutput;
    private final Logger logger;

    public ProgressStatusPrinter(boolean disableAnimation, boolean debugOutput, Logger logger) {
        this.disableAnimation = disableAnimation;
        this.debugOutput = debugOutput;
        this.logger = logger == null ? Logger.getLogger(ProgressStatusPrinter.class.getName()) : logger;
    }

    private synchronized boolean spin() {
        if (this.commandProgress == null || !this.commandProgress.isSpinnerActive() || this.debugOutput || this.lastMsgLength <= 1) {
            return false;
        }
        if (this.spinnerIndex >= 0 && !this.disableAnimation) {
            System.out.print("\b\b");
            this.lastMsgLength -= 2;
        }
        ++this.spinnerIndex;
        if (this.spinnerIndex >= spinner.length) {
            this.spinnerIndex = 0;
        }
        if (this.disableAnimation) {
            System.out.print('.');
            ++this.lastMsgLength;
        } else {
            System.out.print(spinner[this.spinnerIndex]);
            System.out.print(' ');
            this.lastMsgLength += 2;
        }
        return true;
    }

    public synchronized void onAdminCommandEvent(String name, GfSseInboundEvent event) {
        try {
            if ("ProgressStatus/state".equals(name)) {
                ProgressStatusDTO dto = (ProgressStatusDTO)event.getData(ProgressStatusDTO.class, CONTENT_TYPE);
                this.client.mirror(dto);
                this.commandProgress = (CommandProgress)this.client.getProgressStatus();
                if (StringUtils.ok((String)this.commandProgress.getName()) && !StringUtils.ok((String)this.commandProgress.getLastMessage())) {
                    this.commandProgress.progress(strings.getString("progressstatus.message.starting", "Starting"));
                }
                this.printCommandProgress();
            } else if ("ProgressStatus/change".equals(name)) {
                if (this.commandProgress == null) {
                    this.logger.log(Level.WARNING, strings.get("progressstatus.event.applyerror", new Object[]{"Inapplicable progress status event"}));
                    return;
                }
                ProgressStatusEvent pse = (ProgressStatusEvent)event.getData(ProgressStatusEvent.class, CONTENT_TYPE);
                this.client.mirror(pse);
                this.printCommandProgress();
            } else if ("usermessage".equals(name)) {
                String msg = event.getData();
                this.printUserMessage(msg);
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, strings.get("progressstatus.event.parseerror", new Object[]{"Can not parse progress status event"}), ex);
        }
    }

    private synchronized void printUserMessage(String message) {
        if (message == null) {
            return;
        }
        if (this.lastMsgLength > 0) {
            if (this.disableAnimation || this.debugOutput) {
                if (this.disableAnimation) {
                    System.out.println();
                }
                System.out.println(message);
                System.out.print(this.lastMessage);
                if (this.debugOutput) {
                    System.out.println();
                }
            } else {
                System.out.print('\r');
                System.out.println(message);
                int spaceCount = this.lastMsgLength - message.length();
                for (int i = 0; i < spaceCount; ++i) {
                    System.out.print(' ');
                }
                System.out.println();
                System.out.print(this.lastMessage);
            }
        } else {
            System.out.println(message);
        }
    }

    private synchronized void printCommandProgress() {
        if (this.commandProgress != null) {
            String message = ProgressStatusClient.composeMessageForPrint((CommandProgress)this.commandProgress);
            if (StringUtils.ok((String)message) && !message.equals(this.lastMessage)) {
                if (this.disableAnimation || this.debugOutput) {
                    if (!this.firstPrint && !this.debugOutput) {
                        System.out.println();
                    }
                    System.out.print(message);
                    if (this.debugOutput) {
                        System.out.println();
                    }
                } else {
                    int i;
                    if (!this.firstPrint) {
                        System.out.print('\r');
                    }
                    System.out.print(message);
                    System.out.print(' ');
                    int spaceCount = this.lastMsgLength - message.length();
                    for (i = 0; i < spaceCount; ++i) {
                        System.out.print(' ');
                    }
                    for (i = 0; i < spaceCount; ++i) {
                        System.out.print('\b');
                    }
                    this.spinnerIndex = -1;
                }
                this.firstPrint = false;
                this.lastMsgLength = message.length();
                this.lastMessage = message;
            }
            if (!this.debugOutput) {
                if (this.commandProgress.isSpinnerActive()) {
                    if (this.ticker == null) {
                        this.ticker = new Ticker(this.disableAnimation ? 1500L : 500L);
                        this.ticker.start();
                    }
                } else if (this.ticker != null) {
                    this.ticker.stopit();
                    this.ticker = null;
                }
            }
        }
    }

    public synchronized void deleteLastMessage() {
        if (this.lastMsgLength <= 0) {
            return;
        }
        if (this.disableAnimation || this.debugOutput) {
            System.out.println();
        } else {
            System.out.print('\r');
            for (int i = 0; i < this.lastMsgLength; ++i) {
                System.out.print(' ');
            }
            System.out.print('\r');
        }
        if (this.ticker != null) {
            this.ticker.stopit();
            this.ticker = null;
        }
        this.lastMsgLength = 0;
    }

    public synchronized void reset() {
        this.client = new ProgressStatusClient(null);
        this.commandProgress = null;
        this.lastMessage = null;
        this.lastMsgLength = 0;
        this.firstPrint = true;
        if (this.ticker != null) {
            this.ticker.stopit();
            this.ticker = null;
        }
    }

    private class Ticker
    extends Thread {
        private final long pause;
        private volatile boolean stop = false;

        public Ticker(long pause) {
            this.pause = pause;
            this.setDaemon(true);
        }

        public void stopit() {
            this.stop = true;
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.stop) continue;
                return;
            } while (ProgressStatusPrinter.this.spin());
        }
    }
}

