/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.tx;

import ee.jakarta.tck.concurrent.common.transaction.Connections;
import ee.jakarta.tck.concurrent.common.transaction.Counter;
import ee.jakarta.tck.concurrent.common.transaction.TransactedTask;
import ee.jakarta.tck.concurrent.common.transaction.WorkInterface;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;

@WebServlet(value={"/TransactionServlet"})
@DataSourceDefinition(name="java:comp/env/jdbc/ContextServiceDB", className="org.apache.derby.jdbc.EmbeddedDataSource", databaseName="memory:ContextServiceDB", properties={"createDatabase=create"})
public class TransactionServlet
extends TestServlet {
    private static final TestLogger log = TestLogger.get(TransactionServlet.class);
    @Resource(lookup="java:comp/env/jdbc/ContextServiceDB")
    private DataSource ds;
    @Resource(lookup="java:comp/DefaultContextService")
    private ContextService cx;
    @Resource(lookup="java:comp/UserTransaction")
    private UserTransaction ut;

    @Override
    protected void before() throws RemoteException {
        log.enter("before", new Object[0]);
        Connections.setDataSource(this.ds);
        try (Connection conn = Connections.getConnection(true);
             Statement stmt = conn.createStatement();){
            try {
                stmt.executeUpdate("drop table concurrencetable");
            }
            catch (SQLException e) {
                log.finest("Could not drop table, assume table did not exist.");
            }
            stmt.executeUpdate("create table concurrencetable (TYPE_ID int NOT NULL, TYPE_DESC varchar(32), primary key(TYPE_ID))");
            log.exit("before", new Object[0]);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String testTransactionOfExecuteThreadAndCommit() throws ServletException {
        int originCount = Counter.getCount();
        try {
            this.ut.begin();
            try (Connection conn = Connections.getConnection(false);){
                String string;
                block14: {
                    PreparedStatement pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
                    try {
                        pStmt.setInt(1, 99);
                        pStmt.setString(2, "Type-99");
                        pStmt.addBatch();
                        pStmt.setInt(1, 100);
                        pStmt.setString(2, "Type-100");
                        pStmt.addBatch();
                        pStmt.executeBatch();
                        TransactedTask work = new TransactedTask(false, false, "insert into concurrencetable values(?, ?)");
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("jakarta.enterprise.concurrent.TRANSACTION", "USE_TRANSACTION_OF_EXECUTION_THREAD");
                        WorkInterface proxy = (WorkInterface)this.cx.createContextualProxy((Object)work, m, WorkInterface.class);
                        proxy.doWork();
                        this.ut.commit();
                        int afterTransacted = Counter.getCount();
                        string = String.valueOf(afterTransacted - originCount);
                        if (pStmt == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pStmt.close();
                }
                return string;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String testTransactionOfExecuteThreadAndRollback() throws ServletException {
        int originCount = Counter.getCount();
        try {
            this.ut.begin();
            try (Connection conn = Connections.getConnection(false);){
                String string;
                block14: {
                    PreparedStatement pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
                    try {
                        pStmt.setInt(1, 99);
                        pStmt.setString(2, "Type-99");
                        pStmt.addBatch();
                        pStmt.setInt(1, 100);
                        pStmt.setString(2, "Type-100");
                        pStmt.addBatch();
                        pStmt.executeBatch();
                        TransactedTask work = new TransactedTask(false, false, "insert into concurrencetable values(?, ?)");
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("jakarta.enterprise.concurrent.TRANSACTION", "USE_TRANSACTION_OF_EXECUTION_THREAD");
                        WorkInterface proxy = (WorkInterface)this.cx.createContextualProxy((Object)work, m, WorkInterface.class);
                        proxy.doWork();
                        this.ut.rollback();
                        int afterTransacted = Counter.getCount();
                        string = String.valueOf(afterTransacted - originCount);
                        if (pStmt == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pStmt.close();
                }
                return string;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String testSuspendAndCommit() throws ServletException {
        int originCount = Counter.getCount();
        try {
            this.ut.begin();
            try (Connection conn = Connections.getConnection(false);){
                String string;
                block14: {
                    PreparedStatement pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
                    try {
                        pStmt.setInt(1, 99);
                        pStmt.setString(2, "Type-99");
                        pStmt.addBatch();
                        pStmt.setInt(1, 100);
                        pStmt.setString(2, "Type-100");
                        pStmt.addBatch();
                        pStmt.executeBatch();
                        TransactedTask work = new TransactedTask(true, true, "insert into concurrencetable values(?, ?)");
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("jakarta.enterprise.concurrent.TRANSACTION", "SUSPEND");
                        WorkInterface proxy = (WorkInterface)this.cx.createContextualProxy((Object)work, m, WorkInterface.class);
                        proxy.doWork();
                        this.ut.rollback();
                        int afterTransacted = Counter.getCount();
                        string = String.valueOf(afterTransacted - originCount);
                        if (pStmt == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pStmt.close();
                }
                return string;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String testSuspendAndRollback() throws ServletException {
        int originCount = Counter.getCount();
        try {
            this.ut.begin();
            try (Connection conn = Connections.getConnection(false);){
                String string;
                block14: {
                    PreparedStatement pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
                    try {
                        pStmt.setInt(1, 99);
                        pStmt.setString(2, "Type-99");
                        pStmt.addBatch();
                        pStmt.setInt(1, 100);
                        pStmt.setString(2, "Type-100");
                        pStmt.addBatch();
                        pStmt.executeBatch();
                        TransactedTask work = new TransactedTask(false, true, "insert into concurrencetable values(?, ?)");
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("jakarta.enterprise.concurrent.TRANSACTION", "SUSPEND");
                        WorkInterface proxy = (WorkInterface)this.cx.createContextualProxy((Object)work, m, WorkInterface.class);
                        proxy.doWork();
                        this.ut.commit();
                        int afterTransacted = Counter.getCount();
                        string = String.valueOf(afterTransacted - originCount);
                        if (pStmt == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pStmt.close();
                }
                return string;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String testDefaultAndCommit() throws ServletException {
        int originCount = Counter.getCount();
        try {
            this.ut.begin();
            try (Connection conn = Connections.getConnection(false);){
                String string;
                block14: {
                    PreparedStatement pStmt = conn.prepareStatement("insert into concurrencetable values(?, ?)");
                    try {
                        pStmt.setInt(1, 99);
                        pStmt.setString(2, "Type-99");
                        pStmt.addBatch();
                        pStmt.setInt(1, 100);
                        pStmt.setString(2, "Type-100");
                        pStmt.addBatch();
                        pStmt.executeBatch();
                        TransactedTask work = new TransactedTask(true, true, "insert into concurrencetable values(?, ?)");
                        WorkInterface proxy = (WorkInterface)this.cx.createContextualProxy((Object)work, WorkInterface.class);
                        proxy.doWork();
                        this.ut.rollback();
                        int afterTransacted = Counter.getCount();
                        string = String.valueOf(afterTransacted - originCount);
                        if (pStmt == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pStmt.close();
                }
                return string;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

