/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedScheduledExecutorService;

import ee.jakarta.tck.concurrent.common.tasks.CallableTask;
import ee.jakarta.tck.concurrent.common.tasks.CommonTriggers;
import ee.jakarta.tck.concurrent.common.tasks.RunnableTask;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
@Common(value={Common.PACKAGE.TASKS})
public class ManagedScheduledExecutorServiceTests {
    private static final String CALLABLETESTTASK1_RUN_RESULT = "CallableTestTask1";
    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedScheduledExecutorService_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = ManagedScheduledExecutorServiceTests.class.getCanonicalName();
    @Resource(lookup="java:comp/DefaultManagedScheduledExecutorService")
    private ManagedScheduledExecutorService scheduledExecutor;

    @Deployment(name="ManagedScheduledExecutorServiceTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource(ManagedScheduledExecutorServiceTests.class.getPackage(), "web.xml", "web.xml");
    }

    @Assertion(id="JAVADOC:30 SPEC:42 SPEC:42.2 SPEC:43 SPEC:43.1 SPEC:49 SPEC:51 SPEC:54", strategy="Creates and executes a task based on a Trigger. The Trigger determines when the task should run and how often.")
    public void normalScheduleProcess1Test() throws Exception {
        ScheduledFuture result = this.scheduledExecutor.schedule((Runnable)new RunnableTask(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME), (Trigger)new CommonTriggers.OnceTrigger());
        Wait.waitForTaskComplete(result);
        Assertions.assertNull(result.get());
    }

    @Assertion(id="JAVADOC:32", strategy="If command is null.")
    public void nullCommandScheduleProcessTest() {
        Runnable command = null;
        Assertions.assertThrows(NullPointerException.class, () -> this.scheduledExecutor.schedule(command, (Trigger)new CommonTriggers.OnceTrigger()));
    }

    @Assertion(id="JAVADOC:33 SPEC:43 SPEC:43.2 SPEC:54 SPEC:52", strategy="Creates and executes a task based on a Trigger. The Trigger determines when the task should run and how often.")
    public void normalScheduleProcess2Test() throws Exception {
        ScheduledFuture result = this.scheduledExecutor.schedule(new CallableTask<String>(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME, CALLABLETESTTASK1_RUN_RESULT), (Trigger)new CommonTriggers.OnceTrigger());
        Wait.waitForTaskComplete(result);
        Assertions.assertEquals((Object)CALLABLETESTTASK1_RUN_RESULT, result.get());
    }

    @Assertion(id="JAVADOC:35", strategy="If callable is null.")
    public void nullCallableScheduleProcessTest() {
        Callable callable = null;
        Assertions.assertThrows(NullPointerException.class, () -> this.scheduledExecutor.schedule(callable, (Trigger)new CommonTriggers.OnceTrigger()));
    }
}

