/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.managed.forbiddenapi_servlet;

import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.servlet.annotation.WebServlet;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import org.testng.Assert;

@WebServlet(value={"/ForbiddenServlet"})
public class ForbiddenServlet
extends TestServlet {
    private static final String DIDNOT_CATCH_ILLEGALSTATEEXCEPTION = "IllegalStateException expected";

    private ManagedScheduledExecutorService getService() {
        try {
            InitialContext context = new InitialContext();
            ManagedScheduledExecutorService executorService = (ManagedScheduledExecutorService)context.lookup("java:comp/DefaultManagedScheduledExecutorService");
            return executorService;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void before() {
        StaticCounter.reset();
    }

    public void testAwaitTermination() {
        try {
            this.getService().awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)DIDNOT_CATCH_ILLEGALSTATEEXCEPTION);
    }

    public void testIsShutdown() {
        try {
            this.getService().isShutdown();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)DIDNOT_CATCH_ILLEGALSTATEEXCEPTION);
    }

    public void testIsTerminated() {
        try {
            this.getService().isTerminated();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)DIDNOT_CATCH_ILLEGALSTATEEXCEPTION);
    }

    public void testShutdown() {
        try {
            this.getService().shutdown();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)DIDNOT_CATCH_ILLEGALSTATEEXCEPTION);
    }

    public void testShutdownNow() {
        try {
            this.getService().shutdownNow();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)DIDNOT_CATCH_ILLEGALSTATEEXCEPTION);
    }
}

