/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TestLogger {
    private static final String nl = System.lineSeparator();
    private Logger log;

    private TestLogger(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getCanonicalName());
    }

    private TestLogger(String clazz) {
        this.log = Logger.getLogger(clazz);
    }

    public static TestLogger get(Class<?> clazz) {
        return new TestLogger(clazz);
    }

    public static TestLogger get(String clazz) {
        return new TestLogger(clazz);
    }

    public void severe(String s) {
        this.log.severe(s);
    }

    public void severe(String s, Throwable t) {
        this.log.severe(this.messageWithThrowable(s, t));
    }

    public void warning(String s) {
        this.log.warning(s);
    }

    public void warning(String s, Throwable t) {
        this.log.warning(this.messageWithThrowable(s, t));
    }

    public void info(String s) {
        this.log.info(s);
    }

    public void info(String s, Throwable t) {
        this.log.info(this.messageWithThrowable(s, t));
    }

    public void info(String s, Object ... objs) {
        this.log.log(Level.INFO, s + this.getObjectSuffix(objs), this.removeNewLines(objs));
    }

    public void config(String s) {
        this.log.config(s);
    }

    public void config(String s, Throwable t) {
        this.log.config(this.messageWithThrowable(s, t));
    }

    public void fine(String s) {
        this.log.fine(s);
    }

    public void fine(String s, Throwable t) {
        this.log.fine(this.messageWithThrowable(s, t));
    }

    public void finer(String s) {
        this.log.fine(s);
    }

    public void finer(String s, Throwable t) {
        this.log.finer(this.messageWithThrowable(s, t));
    }

    public void finest(String s) {
        this.log.fine(s);
    }

    public void finest(String s, Throwable t) {
        this.log.finest(this.messageWithThrowable(s, t));
    }

    public void enter(Method method, Object ... objs) {
        this.log.log(Level.INFO, "--> " + method.getName() + this.getObjectSuffix(objs), this.removeNewLines(objs));
    }

    public void enter(String method, Object ... objs) {
        this.log.log(Level.INFO, "--> " + method + this.getObjectSuffix(objs), this.removeNewLines(objs));
    }

    public void exit(Method method, Object ... objs) {
        this.log.log(Level.INFO, "<-- " + method.getName() + this.getObjectSuffix(objs), this.removeNewLines(objs));
    }

    public void exit(String method, Object ... objs) {
        this.log.log(Level.INFO, "<-- " + method + this.getObjectSuffix(objs), this.removeNewLines(objs));
    }

    private String messageWithThrowable(String s, Throwable t) {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        t.printStackTrace(pw);
        return s + nl + ((Object)buffer).toString();
    }

    private String getObjectSuffix(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        String suffix = nl + "[ ";
        for (int i = 0; i < objs.length; ++i) {
            suffix = suffix + "{" + i + "}, ";
        }
        return suffix.substring(0, suffix.length() - 2) + " ]";
    }

    private String[] removeNewLines(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return new String[0];
        }
        String[] result = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            result[i] = objs[i] instanceof String ? ((String)objs[i]).replace(nl, "") : String.valueOf(objs[i]).replace(nl, "");
        }
        return result;
    }
}

