/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.edapt.common.ui.IValueValidator;
import org.eclipse.emf.edapt.common.ui.ValueSelectionComposite;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SingleValueSelectionDialog
extends SelectionStatusDialog {
    protected final AdapterFactoryLabelProvider labelProvider;
    private final Collection valueArea;
    private final Object value;
    private ValueSelectionComposite composite;
    private final IValueValidator validator;

    public SingleValueSelectionDialog(Shell parent, Image image, String title, Object value, Collection valueArea, AdapterFactoryLabelProvider labelProvider, IValueValidator validator) {
        super(parent);
        this.setImage(image);
        this.setTitle(title);
        this.value = value;
        this.valueArea = valueArea;
        this.labelProvider = labelProvider;
        this.validator = validator;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().setSize(400, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.composite = new ValueSelectionComposite(contents, this.labelProvider, this.value, false, this.valueArea, this.validator);
        this.composite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SingleValueSelectionDialog.this.validateSelection();
            }
        });
        this.composite.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SingleValueSelectionDialog.this.composite.validSelection()) {
                    SingleValueSelectionDialog.this.okPressed();
                }
            }
        });
        return contents;
    }

    private void validateSelection() {
        if (this.composite.validSelection()) {
            this.getOkButton().setEnabled(true);
        } else {
            this.getOkButton().setEnabled(false);
        }
    }

    public void create() {
        super.create();
        this.validateSelection();
    }

    protected void computeResult() {
        List<Object> selectedElements = this.composite.getSelectedElements();
        this.setResult(selectedElements);
    }
}

