/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.common.ui.IValueValidator;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ValueSelectionComposite
extends Composite {
    protected Pattern filter;
    private TreeViewer filteredViewer;
    private final boolean multi;
    protected final AdapterFactoryLabelProvider labelProvider;
    private final Collection valueArea;
    private final Object value;
    private final IValueValidator validator;

    public ValueSelectionComposite(Composite parent, AdapterFactoryLabelProvider labelProvider, Object value, boolean multi, Collection valueArea, IValueValidator validator) {
        super(parent, 0);
        this.labelProvider = labelProvider;
        this.multi = multi;
        this.value = value;
        this.valueArea = valueArea;
        this.validator = validator;
        this.filter = Pattern.compile(".*");
        this.init();
    }

    private void init() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        this.createFilterText();
        this.createFilteredViewer();
        this.selectValue();
    }

    private void createFilterText() {
        final Text filterText = new Text((Composite)this, 2048);
        GridData data = new GridData(768);
        filterText.setLayoutData((Object)data);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValueSelectionComposite.this.setFilter(filterText.getText());
            }
        });
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ValueSelectionComposite.this.filteredViewer.getControl().setFocus();
                }
            }
        });
        filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ValueSelectionComposite.this.filteredViewer.getControl().setFocus();
                    EObject matchingElement = ValueSelectionComposite.this.getFirstMatchingElement();
                    if (matchingElement != null) {
                        ValueSelectionComposite.this.filteredViewer.setSelection((ISelection)new StructuredSelection((Object)matchingElement));
                    }
                }
            }
        });
    }

    private void setFilter(String pattern) {
        StringBuffer escaped = new StringBuffer();
        String[] starSplit = pattern.split("\\*");
        int i = 0;
        int n = starSplit.length;
        while (i < n) {
            String[] questionSplit;
            if (i > 0) {
                escaped.append(".*");
            }
            String star = starSplit[i];
            String[] stringArray = questionSplit = star.split("\\?");
            int n2 = questionSplit.length;
            int n3 = 0;
            while (n3 < n2) {
                String question = stringArray[n3];
                if (i > 0) {
                    escaped.append(".?");
                }
                escaped.append(Pattern.quote(question));
                ++n3;
            }
            ++i;
        }
        escaped.append(".*");
        this.filter = Pattern.compile(escaped.toString(), 2);
        this.refreshFilteredViewer();
    }

    protected void refreshFilteredViewer() {
        this.filteredViewer.getControl().setRedraw(false);
        this.filteredViewer.refresh(true);
        this.filteredViewer.expandAll();
        ISelection oldSelection = this.filteredViewer.getSelection();
        Object firstValue = this.valueArea.iterator().next();
        this.filteredViewer.setSelection((ISelection)new StructuredSelection(firstValue), true);
        this.filteredViewer.setSelection(oldSelection);
        this.filteredViewer.getControl().setRedraw(true);
    }

    private void createFilteredViewer() {
        int style = 2048;
        if (this.multi) {
            style |= 2;
        }
        this.filteredViewer = new TreeViewer((Composite)this, style);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 400;
        this.filteredViewer.getControl().setLayoutData((Object)data);
        this.filteredViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.labelProvider.getAdapterFactory()){

            public Object[] getElements(Object object) {
                Collection objects = (Collection)object;
                return objects.toArray();
            }
        });
        this.filteredViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)new Decorator()));
        this.filteredViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (this.select(element)) {
                    return true;
                }
                Object[] objectArray = ((ITreeContentProvider)ValueSelectionComposite.this.filteredViewer.getContentProvider()).getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            private boolean select(Object element) {
                return ValueSelectionComposite.this.isSelectable(element);
            }
        });
        this.filteredViewer.setInput((Object)this.valueArea);
        this.filteredViewer.expandAll();
    }

    public boolean validSelection() {
        List<Object> elements = this.getSelectedElements();
        if (elements.size() == 0) {
            return false;
        }
        for (Object element : elements) {
            if (this.validator.isPossibleValue(element)) continue;
            return false;
        }
        return true;
    }

    private void selectValue() {
        if (this.value != null) {
            if (this.multi) {
                if (this.value instanceof Collection) {
                    this.filteredViewer.setSelection((ISelection)new StructuredSelection(new ArrayList((Collection)this.value)));
                }
            } else {
                this.filteredViewer.setSelection((ISelection)new StructuredSelection(this.value));
            }
        }
    }

    private EObject getFirstMatchingElement() {
        TreeItem item = this.getFirstMatchingItem(this.filteredViewer.getTree().getItems());
        if (item != null) {
            return (EObject)item.getData();
        }
        return null;
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        int i = 0;
        int n = items.length;
        while (i < n) {
            TreeItem item = items[i];
            if (this.isSelectable(item.getData())) {
                return item;
            }
            if ((item = this.getFirstMatchingItem(item.getItems())) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public List<Object> getSelectedElements() {
        return SelectionUtils.getSelectedElements(this.filteredViewer.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.filteredViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.filteredViewer.removeSelectionChangedListener(listener);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.filteredViewer.addDoubleClickListener(listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.filteredViewer.removeDoubleClickListener(listener);
    }

    private boolean isSelectable(Object element) {
        if (this.validator.isPossibleValue(element)) {
            String label = this.labelProvider.getText(element);
            Matcher matcher = this.filter.matcher(label);
            return matcher.matches();
        }
        return false;
    }

    private class Decorator
    implements ILabelDecorator,
    IFontDecorator {
        private Decorator() {
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Font decorateFont(Object element) {
            if (ValueSelectionComposite.this.isSelectable(element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }
}

