/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.editsupport;

import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emfforms.internal.core.services.label.BundleResolver;
import org.eclipse.emfforms.internal.core.services.label.BundleResolverImpl;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.emfspecificservice.EMFSpecificService;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.osgi.framework.Bundle;

public class EMFFormsEditSupportImpl
implements EMFFormsEditSupport {
    private EMFFormsDatabinding emfFormsDatabinding;
    private EMFSpecificService emfSpecificService;
    private ReportService reportService;
    private final BundleResolver bundleResolver = new BundleResolverImpl();
    private EMFFormsLocalizationService emfFormsLocalizationService;
    private static final String LITERAL_NAME = "_UI_%1$s_%2$s_literal";

    protected void setEMFFormsLocalizationService(EMFFormsLocalizationService emfFormsLocalizationService) {
        this.emfFormsLocalizationService = emfFormsLocalizationService;
    }

    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    protected void setEMFSpecificService(EMFSpecificService emfSpecificService) {
        this.emfSpecificService = emfSpecificService;
    }

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public boolean isMultiLine(VDomainModelReference domainModelReference, EObject rootObject) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return false;
        }
        return itemPropertyDescriptor.isMultiLine((Object)value);
    }

    @Override
    public boolean canSetProperty(VDomainModelReference domainModelReference, EObject rootObject) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return false;
        }
        return itemPropertyDescriptor.canSetProperty((Object)value);
    }

    @Override
    public String getText(VDomainModelReference domainModelReference, EObject rootObject, Object element) {
        String result;
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        Assert.create((Object)element).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return ex.getMessage();
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        if (EAttribute.class.isInstance(structuralFeature) && EcorePackage.eINSTANCE.getEEnum().isInstance((Object)((EAttribute)EAttribute.class.cast(structuralFeature)).getEType()) && (result = this.getEnumLiteral(structuralFeature, element)) != null) {
            return result;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return null;
        }
        IItemLabelProvider labelProvider = itemPropertyDescriptor.getLabelProvider((Object)rootObject);
        return labelProvider.getText(element);
    }

    private String getEnumLiteral(EStructuralFeature feature, Object element) {
        EClass eContainingClass = feature.getEContainingClass();
        try {
            Bundle bundle = this.bundleResolver.getEditBundle(eContainingClass);
            String key = String.format(LITERAL_NAME, feature.getEType().getName(), ((EEnum)EEnum.class.cast(feature.getEType())).getEEnumLiteralByLiteral(((Enum)Enum.class.cast(element)).toString()).getName());
            return this.emfFormsLocalizationService.getString(bundle, key);
        }
        catch (BundleResolver.NoBundleFoundException noBundleFoundException) {
            return null;
        }
    }

    @Override
    public Object getImage(VDomainModelReference domainModelReference, EObject rootObject, Object element) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return ex.getMessage();
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return null;
        }
        IItemLabelProvider labelProvider = itemPropertyDescriptor.getLabelProvider((Object)rootObject);
        return labelProvider.getImage(element);
    }

    private void reportMissingPropertyDescriptor(EObject value, EStructuralFeature structuralFeature) {
        this.reportService.report(new AbstractReport(String.format("No IItemPropertyDescriptor for feature %2$s in EClass %1$s found.", value.eClass().getName(), structuralFeature.getName())));
    }
}

