/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerColumnBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerComposite
extends AbstractTableViewerComposite {
    private TableViewer tableViewer;

    TableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization customization, IObservableValue title, IObservableValue tooltip) {
        super(parent, style, inputObject, customization, title, tooltip);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    protected AbstractTableViewer createTableViewer(TableViewerSWTCustomization customization, Composite viewerComposite) {
        this.tableViewer = (TableViewer)customization.createTableViewer(viewerComposite);
        return this.tableViewer;
    }

    @Override
    protected AbstractColumnLayout createLayout(Composite viewerComposite) {
        TableColumnLayout layout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)layout);
        return layout;
    }

    @Override
    public Widget[] getColumns() {
        return this.tableViewer.getTable().getColumns();
    }

    @Override
    public void addColumnListener(ControlListener columnlistener) {
        int i = 0;
        while (i < this.tableViewer.getTable().getColumns().length) {
            TableColumn tableColumn = this.tableViewer.getTable().getColumns()[i];
            tableColumn.addControlListener(columnlistener);
            ++i;
        }
    }

    @Override
    public TableControl getTableControl() {
        return new TableControl(){

            @Override
            public boolean isDisposed() {
                return TableViewerComposite.this.getTableViewer().getTable().isDisposed();
            }

            @Override
            public int getItemHeight() {
                return TableViewerComposite.this.getTableViewer().getTable().getItemHeight();
            }

            @Override
            public boolean getHeaderVisible() {
                return TableViewerComposite.this.getTableViewer().getTable().getHeaderVisible();
            }

            @Override
            public int getHeaderHeight() {
                return TableViewerComposite.this.getTableViewer().getTable().getHeaderHeight();
            }

            @Override
            public int getItemCount() {
                return TableViewerComposite.this.getTableViewer().getTable().getItemCount();
            }
        };
    }

    @Override
    protected ViewerColumn createColumn(TableViewerSWTCustomization.ColumnDescription columnDescription, EMFDataBindingContext emfDataBindingContext, AbstractTableViewer tableViewer) {
        TableViewerColumnBuilder builder = TableViewerColumnBuilder.create();
        TableViewerColumn column = builder.setData(columnDescription.getData()).setData("resizable", columnDescription.isResizeable()).setMoveable(columnDescription.isMoveable()).setStyle(columnDescription.getStyleBits()).setData("weight", columnDescription.getWeight()).setData("min_width", columnDescription.getMinWidth()).build(this.getTableViewer());
        IObservableValue text = columnDescription.getColumnText();
        emfDataBindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)column.getColumn()), text);
        IObservableValue tooltipText = columnDescription.getColumnTooltip();
        emfDataBindingContext.bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)column.getColumn()), tooltipText);
        column.setLabelProvider(columnDescription.createLabelProvider(tableViewer));
        Optional<EditingSupport> editingSupport = columnDescription.createEditingSupport(tableViewer);
        if (editingSupport.isPresent()) {
            column.setEditingSupport((EditingSupport)editingSupport.get());
        }
        if (columnDescription.getColumnImage().isPresent()) {
            column.getColumn().setImage((Image)columnDescription.getColumnImage().get());
        }
        return column;
    }

    @Override
    public void setComparator(final TableViewerComparator comparator, List<Integer> sortableColumns) {
        int i = 0;
        while (i < this.getTableViewer().getTable().getColumns().length) {
            if (sortableColumns.contains(i)) {
                final int j = i;
                final TableColumn tableColumn = this.getTableViewer().getTable().getColumns()[i];
                SelectionAdapter selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        comparator.setColumn(j);
                        int dir = comparator.getDirection();
                        TableViewerComposite.this.tableViewer.getTable().setSortDirection(dir);
                        TableViewerComposite.this.tableViewer.getTable().setSortColumn(tableColumn);
                        TableViewerComposite.this.tableViewer.refresh();
                    }
                };
                tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            }
            ++i;
        }
    }
}

