/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sirius.diagram.ui.business.api.image.ITreeImagesContentProvider;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageFiltersUtils;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ImageWorkspaceContentProvider
implements ITreeImagesContentProvider {
    private static final char SEPARATOR = File.separatorChar;
    private WorkbenchContentProvider wcp;
    private final String workspacePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + SEPARATOR;

    public ImageWorkspaceContentProvider() {
        this.wcp = new WorkbenchContentProvider();
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = new Object[]{};
        if (inputElement instanceof IContainer) {
            IContainer iContainer = (IContainer)inputElement;
            result = iContainer.getLocation().toFile().listFiles();
        } else if (inputElement instanceof File) {
            File file = (File)inputElement;
            result = file.listFiles();
        } else {
            result = this.wcp.getChildren(inputElement);
        }
        result = result == null ? new Object[]{} : this.keepImagesAndDirectories(result);
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        if (parentElement instanceof IContainer) {
            IContainer iContainer = (IContainer)parentElement;
            result = iContainer.getLocation().toFile().listFiles();
        } else if (parentElement instanceof File) {
            File file = (File)parentElement;
            result = file.listFiles();
        } else {
            result = this.wcp.getChildren(parentElement);
        }
        result = result == null ? new Object[]{} : this.keepImagesAndDirectories(result);
        return result;
    }

    private Object[] keepImagesAndDirectories(Object[] result) {
        ArrayList<Object> visibleFiles = new ArrayList<Object>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof File) {
                boolean isImageFile;
                File file = (File)element;
                boolean isDirectoryToAdd = file.isDirectory() && file.listFiles().length >= 1 && !file.getName().startsWith(".");
                boolean bl = isImageFile = !file.isDirectory() && this.getImageFile(element).isPresent();
                if (isDirectoryToAdd || isImageFile) {
                    visibleFiles.add(element);
                }
            }
            ++n2;
        }
        return visibleFiles.toArray();
    }

    public Object getParent(Object element) {
        File file;
        File parentFile;
        Object result = this.wcp.getParent(element);
        if (result == null && element instanceof File && (parentFile = (file = (File)element).getParentFile()) != null) {
            result = !this.workspacePath.equals(String.valueOf(file.getPath()) + SEPARATOR) ? parentFile : null;
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public Optional<File> getImageFile(Object element) {
        File file;
        Optional<File> result = Optional.empty();
        if (element instanceof File && !((File)element).isDirectory() && ImageFiltersUtils.isSupportedImageFile((file = (File)element).getName())) {
            result = Optional.of(file);
        }
        return result;
    }

    @Override
    public Optional<String> getPath(Object element) {
        File file;
        String filePath;
        Optional<String> result = Optional.empty();
        if (element instanceof File && (filePath = (file = (File)element).getPath()).startsWith(this.workspacePath)) {
            result = Optional.of(filePath.substring(this.workspacePath.length()));
        }
        return result;
    }
}

