/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.image.refresh;

import com.google.common.collect.Iterables;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.internal.image.refresh.WorkspaceImageChangeDetector;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkspaceImageFigureRefresher
implements IResourceChangeListener {
    public void init() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                WorkspaceImageChangeDetector deltaVisitor = new WorkspaceImageChangeDetector();
                delta.accept((IResourceDeltaVisitor)deltaVisitor);
                if (deltaVisitor.isAtLeastOneEditorToRefresh()) {
                    this.refreshOpenedEditors();
                }
            }
            catch (CoreException e) {
                DiagramPlugin.getDefault().logError(Messages.WorkspaceImageFigureRefresher_imageDescriptorUpdateError, (Throwable)e);
            }
        }
    }

    private void refreshOpenedEditors() {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IEditorPart editor;
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (editor = activePage.getActiveEditor()) instanceof DiagramDocumentEditor) {
                    WorkspaceImageFigureRefresher.refreshAllEditPart(((DiagramDocumentEditor)editor).getDiagramEditPart());
                }
            }
        });
    }

    public static void refreshAllEditPart(DiagramEditPart diagramEditPart) {
        Iterable editParts = Iterables.filter((Iterable)diagramEditPart.getChildren(), GraphicalEditPart.class);
        for (GraphicalEditPart editPart : editParts) {
            if (!editPart.isActive()) continue;
            editPart.refresh();
            WorkspaceImageFigureRefresher.refreshChildrenEditPart(editPart);
        }
    }

    private static void refreshChildrenEditPart(GraphicalEditPart parentEditPart) {
        Iterable editParts = Iterables.filter((Iterable)parentEditPart.getChildren(), GraphicalEditPart.class);
        for (GraphicalEditPart editPart : editParts) {
            editPart.refresh();
            WorkspaceImageFigureRefresher.refreshChildrenEditPart(editPart);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

