/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.image;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.ui.business.api.image.ITreeImagesContentProvider;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageFiltersUtils;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ImageWorkspaceContentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ImageWorkspaceLabelProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.TreeImagesGalleryComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ImageSelectionDialog
extends Dialog {
    static final int TREE_WIDTH = 270;
    static final int TREE_HEIGHT = 210;
    protected TreeImagesGalleryComposite treeGalleryComposite;
    private String title = Messages.ResourceSelectionDialog_title;
    private List<ViewerFilter> filters;
    private Object root = ResourcesPlugin.getWorkspace().getRoot();
    private ITreeImagesContentProvider contentProvider;
    private ILabelProvider labelProvider = new ImageWorkspaceLabelProvider();

    public ImageSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.contentProvider = new ImageWorkspaceContentProvider();
        this.filters = new ArrayList<ViewerFilter>();
        this.filters.add(ImageFiltersUtils.createFileExtensionFilter());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.treeGalleryComposite = TreeImagesGalleryComposite.createTreeImagesGalleryComposite(container, this.getLabelProvider(), this.getContentProvider(), this.getFilters(), this.getRoot());
        Tree treeWidget = this.treeGalleryComposite.getViewer().getTree();
        GridData data = (GridData)treeWidget.getLayoutData();
        data.widthHint = 270;
        data.heightHint = 210;
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        this.treeGalleryComposite.createListenerForOKButton(okButton);
        return buttonBar;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public boolean close() {
        Job.getJobManager().cancel((Object)TreeImagesGalleryComposite.REFRESH_IMAGE_JOB_FAMILY);
        this.treeGalleryComposite.dispose();
        return super.close();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ViewerFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ViewerFilter> filters) {
        this.filters = filters;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public ITreeImagesContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ITreeImagesContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public String getImagePath() {
        return this.treeGalleryComposite.getSelectedImagePath();
    }
}

