/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ISessionImporter;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.wizards.SessionImportPage1;
import org.eclipse.eclemma.internal.ui.wizards.SessionImportPage2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class SessionImportWizard
extends Wizard
implements IImportWizard {
    public static final String ID = "org.eclipse.eclemma.ui.sessionImportWizard";
    private static final String SETTINGSID = "SessionImportWizard";
    private SessionImportPage1 page1;
    private SessionImportPage2 page2;

    public SessionImportWizard() {
        IDialogSettings pluginsettings = EclEmmaUIPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardsettings = pluginsettings.getSection(SETTINGSID);
        if (wizardsettings == null) {
            wizardsettings = pluginsettings.addNewSection(SETTINGSID);
        }
        this.setDialogSettings(wizardsettings);
        this.setWindowTitle(UIMessages.ImportSession_title);
        this.setDefaultPageImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/wizban/import_session.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page1 = new SessionImportPage1();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new SessionImportPage2();
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        this.page1.saveWidgetValues();
        this.page2.saveWidgetValues();
        return this.importSession();
    }

    private boolean importSession() {
        final ISessionImporter importer = CoverageTools.getImporter();
        importer.setDescription(this.page2.getSessionDescription());
        importer.setExecutionDataSource(this.page1.getExecutionDataSource());
        importer.setScope(this.page2.getScope());
        importer.setCopy(this.page1.getCreateCopy());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    importer.importSession(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ite) {
            Throwable ex = ite.getTargetException();
            EclEmmaUIPlugin.log(ex);
            String title = UIMessages.ImportSessionErrorDialog_title;
            String msg = UIMessages.ImportSessionErrorDialog_message;
            IStatus status = EclEmmaUIPlugin.errorStatus(String.valueOf(ex.getMessage()), ex);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)msg, (IStatus)status);
            return false;
        }
        return true;
    }
}

