/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.Logger;
import org.eclipse.ease.tools.StringTools;

public final class ResourceTools {
    private static final String PROJECT_SCHEME = "project";
    private static final String PROJECT_PREFIX = "project://";
    private static final String WORKSPACE_SCHEME = "workspace";
    private static final String WORKSPACE_PREFIX = "workspace://";
    private static final String FILE_SCHEME = "file";
    private static final String FILE_PREFIX = "file://";
    private static final String SCRIPT_SCHEME = "script";
    private static final Pattern WINDOWS_LOCAL_FILE_PATTERN = Pattern.compile("(?:file:///?)?([A-Z]:[/\\\\].*)");
    private static final Pattern WINDOWS_NETWORK_FILE_PATTERN = Pattern.compile("(?:file\\:)?((?://|\\\\\\\\)[^:/][^:]*)");
    public static final Object VIRTUAL_WINDOWS_ROOT = new File("/");

    @Deprecated
    private ResourceTools() {
    }

    public static Object resolve(Object location, Object parent) {
        IPath parentPath;
        if (location instanceof File || location instanceof IResource || location instanceof URI || location instanceof URL) {
            return location;
        }
        if (location == null || location.toString().trim().isEmpty()) {
            Object resolvedParent = ResourceTools.resolve(parent);
            if (resolvedParent instanceof IFile) {
                return ((IFile)resolvedParent).getParent();
            }
            if (resolvedParent instanceof File && ((File)resolvedParent).isFile()) {
                return ((File)resolvedParent).getParentFile();
            }
            return resolvedParent;
        }
        String locationStr = location.toString();
        if (ResourceTools.isAbsolute(locationStr)) {
            return ResourceTools.resolve(location);
        }
        if (!ResourceTools.exists(parent = ResourceTools.resolve(parent))) {
            return null;
        }
        if (parent instanceof IResource) {
            Object resolvedTarget;
            if (locationStr.startsWith(PROJECT_PREFIX)) {
                String targetPath = WORKSPACE_PREFIX + ((IResource)parent).getProject().getName() + "/" + locationStr.substring(PROJECT_PREFIX.length());
                return ResourceTools.resolve(targetPath);
            }
            parentPath = parent instanceof IFile ? ((IResource)parent).getParent().getFullPath() : ((IResource)parent).getFullPath();
            Path locationPath = new Path(locationStr);
            IPath targetPath = locationPath.segmentCount() > parentPath.segmentCount() ? ResourceTools.appendPath(parentPath, (IPath)locationPath) : parentPath.append((IPath)locationPath);
            if (targetPath != null && (resolvedTarget = ResourceTools.resolve(WORKSPACE_PREFIX + targetPath.makeRelative().toPortableString())) != null) {
                return resolvedTarget;
            }
            parent = ResourceTools.toFile(parent);
        }
        if (parent instanceof File) {
            parentPath = new Path(((File)parent).isFile() ? ((File)parent).getParentFile().getAbsolutePath() : ((File)parent).getAbsolutePath());
            IPath targetPath = parentPath.append((IPath)new Path(locationStr));
            return targetPath.toFile();
        }
        if (parent instanceof URL) {
            try {
                parent = ((URL)parent).toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (parent instanceof URI) {
            return ((URI)parent).resolve(locationStr);
        }
        return null;
    }

    private static IPath appendPath(IPath parentPath, IPath locationPath) {
        if (locationPath.segmentCount() > 0) {
            IPath newParent = parentPath.append(locationPath.segment(0));
            if (parentPath.equals((Object)newParent)) {
                return null;
            }
            return ResourceTools.appendPath(newParent, locationPath.removeFirstSegments(1));
        }
        return parentPath;
    }

    public static boolean exists(Object resource) {
        if (resource instanceof IResource) {
            return ((IResource)resource).exists();
        }
        if (resource instanceof File) {
            return ((File)resource).exists();
        }
        return resource instanceof URI || resource instanceof URL;
    }

    public static boolean isFile(Object resource) {
        if (ResourceTools.exists(resource)) {
            if (resource instanceof IFile) {
                return true;
            }
            if (resource instanceof File && ((File)resource).isFile()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFolder(Object resource) {
        if (ResourceTools.exists(resource)) {
            if (resource instanceof IContainer) {
                return true;
            }
            if (resource instanceof File && ((File)resource).isDirectory()) {
                return true;
            }
        }
        return false;
    }

    public static Object resolve(Object location) {
        if (location instanceof File || location instanceof IResource || location instanceof URI || location instanceof URL) {
            return location;
        }
        if (location == null || location.toString().trim().isEmpty()) {
            return null;
        }
        String locationStr = location.toString();
        if (ResourceTools.isAbsolute(locationStr)) {
            if (locationStr.startsWith(WORKSPACE_PREFIX)) {
                if (WORKSPACE_PREFIX.equals(locationStr)) {
                    return ResourceTools.getWorkspace();
                }
                Path path = new Path(locationStr.substring(WORKSPACE_PREFIX.length()));
                if (path.isEmpty()) {
                    return ResourceTools.getWorkspace();
                }
                IProject project = ResourceTools.getWorkspace().getProject(path.segment(0));
                if (project != null) {
                    if (path.segmentCount() == 1) {
                        return project;
                    }
                    IFolder folder = project.getFolder(path.removeFirstSegments(1));
                    if (folder.exists()) {
                        return folder;
                    }
                    return project.getFile(path.removeFirstSegments(1));
                }
            } else {
                if (locationStr.startsWith(FILE_PREFIX)) {
                    if (ResourceTools.isWindows()) {
                        Matcher matcher = WINDOWS_LOCAL_FILE_PATTERN.matcher(locationStr);
                        if (matcher.matches()) {
                            return new File(matcher.group(1));
                        }
                        matcher = WINDOWS_NETWORK_FILE_PATTERN.matcher(locationStr);
                        if (matcher.matches()) {
                            return new File(matcher.group(1));
                        }
                        if ("file:///".equals(locationStr) || FILE_PREFIX.equals(locationStr)) {
                            return VIRTUAL_WINDOWS_ROOT;
                        }
                        return null;
                    }
                    if (locationStr.startsWith("file:///")) {
                        return new File(locationStr.substring(7));
                    }
                    if (locationStr.startsWith(FILE_PREFIX)) {
                        return new File(locationStr.substring(6));
                    }
                    return new File(locationStr);
                }
                if (locationStr.startsWith(SCRIPT_SCHEME)) {
                    try {
                        return new URL(locationStr);
                    }
                    catch (MalformedURLException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (locationStr.contains(":/") && locationStr.indexOf(":/") != 1) {
                    try {
                        return ResourceTools.createURI(locationStr);
                    }
                    catch (MalformedURLException e) {
                        return URI.create(locationStr);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                return new File(locationStr);
            }
        }
        return null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static URI createURI(String address) throws MalformedURLException, URISyntaxException {
        URL url = new URL(address);
        return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    private static IWorkspaceRoot getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static boolean isAbsolute(String location) {
        if (location.startsWith(PROJECT_PREFIX)) {
            return false;
        }
        if (location.contains(":/")) {
            return true;
        }
        if (WINDOWS_LOCAL_FILE_PATTERN.matcher(location).matches()) {
            return true;
        }
        if (WINDOWS_NETWORK_FILE_PATTERN.matcher(location).matches()) {
            return true;
        }
        return new Path(location).isAbsolute();
    }

    public static String toProjectRelativeLocation(IResource resource) {
        return PROJECT_PREFIX + resource.getProjectRelativePath().toPortableString();
    }

    public static String toAbsoluteLocation(Object location, Object parent) {
        Object file = ResourceTools.resolve(location, parent);
        if (file instanceof IResource) {
            return "workspace:/" + ((IResource)file).getFullPath().toPortableString();
        }
        if (file instanceof File) {
            if (ResourceTools.isWindows()) {
                return "file:///" + ((File)file).toString().replaceAll("\\\\", "/");
            }
            return FILE_PREFIX + ((File)file).toString();
        }
        if (file != null) {
            return file.toString();
        }
        return null;
    }

    public static String toRelativeLocation(Object resource, Object parent) {
        IPath resourcePath;
        IPath parentPath;
        if ((resource = ResourceTools.resolve(resource)) == null) {
            return null;
        }
        if ((parent = ResourceTools.resolve(parent)) == null) {
            return null;
        }
        if (ResourceTools.isFile(parent)) {
            if (parent instanceof IFile) {
                parent = ((IFile)parent).getParent();
            } else if (parent instanceof File) {
                parent = ((File)parent).getParentFile();
            }
        }
        if (resource instanceof IResource && parent instanceof IResource) {
            parentPath = ((IResource)parent).getFullPath();
            resourcePath = ((IResource)resource).getFullPath();
        } else {
            resource = ResourceTools.toFile(resource);
            parent = ResourceTools.toFile(parent);
            try {
                parentPath = new Path(((File)parent).getCanonicalPath());
                resourcePath = new Path(((File)resource).getCanonicalPath());
                if (!parentPath.getDevice().equals(resourcePath.getDevice())) {
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        int matchingSegments = parentPath.matchingFirstSegments(resourcePath);
        parentPath = parentPath.removeFirstSegments(matchingSegments);
        resourcePath = resourcePath.removeFirstSegments(matchingSegments);
        int index = 0;
        while (index < parentPath.segmentCount()) {
            resourcePath = new Path("..").append(resourcePath);
            ++index;
        }
        return resourcePath.toPortableString();
    }

    public static InputStream getInputStream(Object location) {
        if (location instanceof InputStream) {
            return (InputStream)location;
        }
        try {
            Object resource = ResourceTools.resolve(location);
            if (resource instanceof IFile) {
                return ((IFile)resource).getContents();
            }
            if (resource instanceof File) {
                return new FileInputStream((File)resource);
            }
            if (resource instanceof URI) {
                return ((URI)resource).toURL().openStream();
            }
            if (location != null) {
                return new URL(location.toString()).openStream();
            }
        }
        catch (Exception e) {
            Logger.error("org.eclipse.ease", "Cannot open stream for \"" + location + "\"", e);
        }
        return null;
    }

    public static String toString(Object location) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(ResourceTools.getInputStream(location));
            return StringTools.toString(inputStream);
        }
        catch (IOException e) {
            Logger.error("org.eclipse.ease", "Cannot read from resource \"" + location + "\"", e);
            return null;
        }
    }

    public static String toString(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return ResourceTools.toString(new InputStreamReader(stream));
    }

    public static String toString(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        char[] buffer = new char[1024];
        int bytes = 0;
        do {
            if ((bytes = reader.read(buffer)) <= 0) continue;
            out.append(buffer, 0, bytes);
        } while (bytes != -1);
        return out.toString();
    }

    public static File toFile(Object resource) {
        if (resource instanceof File) {
            return (File)resource;
        }
        if (resource instanceof IResource) {
            if (((IResource)resource).getRawLocation() != null) {
                return ((IResource)resource).getRawLocation().toFile();
            }
            return ((IResource)resource).getLocation().toFile();
        }
        return null;
    }

    public static void createFolder(IContainer folder) throws CoreException {
        if (!folder.exists()) {
            if (!folder.getParent().exists()) {
                ResourceTools.createFolder(folder.getParent());
            }
            if (folder instanceof IFolder) {
                ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public static class NonClosingInputStream
    extends InputStream {
        private final InputStream fBaseStream;

        public NonClosingInputStream(InputStream baseStream) {
            this.fBaseStream = baseStream;
        }

        @Override
        public int read() throws IOException {
            return this.fBaseStream.read();
        }

        @Override
        public int available() throws IOException {
            return this.fBaseStream.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.fBaseStream.skip(n);
        }

        @Override
        public boolean markSupported() {
            return this.fBaseStream.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.fBaseStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.fBaseStream.reset();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.fBaseStream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.fBaseStream.read(b);
        }
    }
}

