/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LibrariesTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private final List<File> mLibraries = new ArrayList<File>();
    private ListViewer listViewer;

    private static String serializeLibraries(List<File> libraries) {
        StringBuffer result = new StringBuffer();
        for (File file : libraries) {
            result.append(File.pathSeparator);
            result.append(file.getAbsolutePath());
        }
        if (result.length() > 0) {
            result.delete(0, File.pathSeparator.length());
        }
        return result.toString();
    }

    private static Collection<File> unserializeLibraries(String libraries) {
        String[] elements = libraries.split(File.pathSeparator);
        ArrayList<File> result = new ArrayList<File>(elements.length);
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                result.add(new File(element.trim()));
            }
            ++n2;
        }
        return result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Libraries", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.mLibraries.clear();
        try {
            String libraries = configuration.getAttribute("Libraries", "");
            this.mLibraries.addAll(LibrariesTab.unserializeLibraries(libraries));
        }
        catch (CoreException coreException) {}
        this.listViewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Libraries", LibrariesTab.serializeLibraries(this.mLibraries));
    }

    public String getMessage() {
        return "Please select JAR files to load within the interpreter.";
    }

    public String getName() {
        return "Libraries";
    }

    public void createControl(final Composite parent) {
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)new GridLayout(2, false));
        Label lblStartupCode = new Label(topControl, 0);
        lblStartupCode.setText("Additional libraries:");
        this.setControl((Control)topControl);
        new Label(topControl, 0);
        this.listViewer = new ListViewer(topControl, 2560);
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewer.setInput(this.mLibraries);
        Composite composite = new Composite(topControl, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        FillLayout fl_composite = new FillLayout(512);
        fl_composite.spacing = 10;
        composite.setLayout((Layout)fl_composite);
        Button btnNewButton = new Button(composite, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.jar"});
                dialog.setFilterNames(new String[]{"Java Archives"});
                String filePath = dialog.open();
                if (filePath != null) {
                    String[] stringArray = dialog.getFileNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filename = stringArray[n2];
                        LibrariesTab.this.mLibraries.add(new File(filename));
                        ++n2;
                    }
                    LibrariesTab.this.listViewer.refresh();
                    LibrariesTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        btnNewButton.setText("Add JARs...");
        Button btnNewButton_1 = new Button(composite, 0);
        btnNewButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LibrariesTab.this.listViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof File) {
                    LibrariesTab.this.mLibraries.remove(element);
                    LibrariesTab.this.listViewer.refresh();
                    LibrariesTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        btnNewButton_1.setText("Remove");
    }
}

