/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.scripts.ScriptEditorInput;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EditScript
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "org.eclipse.ease.commands.script.edit";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof IScript)) continue;
                final Object content = ((IScript)element).getResource();
                if (content instanceof IFile && ((IFile)content).exists()) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)content));
                    }
                    catch (PartInitException partInitException) {
                        Logger.logError((String)("Could not open editor for file " + content));
                    }
                    continue;
                }
                if (!(content instanceof File) || !((File)content).exists()) continue;
                ScriptType type = ((IScript)element).getType();
                IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo." + type.getDefaultExtension());
                if (descriptor == null) continue;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    final ScriptEditorInput editorInput = new ScriptEditorInput((IScript)element);
                    final IEditorPart editor = page.openEditor((IEditorInput)editorInput, descriptor.getId());
                    editor.addPropertyListener(new IPropertyListener(){

                        public void propertyChanged(Object source, int propId) {
                            if (257 == propId && editor instanceof AbstractDecoratedTextEditor && !editor.isDirty()) {
                                block15: {
                                    IDocumentProvider documentProvider = ((AbstractTextEditor)editor).getDocumentProvider();
                                    String newSource = documentProvider.getDocument((Object)editorInput).get();
                                    FileOutputStream outputStream = null;
                                    try {
                                        try {
                                            outputStream = new FileOutputStream((File)content);
                                            outputStream.write(newSource.getBytes());
                                        }
                                        catch (Exception e) {
                                            Logger.logError((String)"Could not store recorded script.", (Throwable)e);
                                            if (outputStream != null) {
                                                try {
                                                    outputStream.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                            break block15;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (outputStream != null) {
                                            try {
                                                outputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        throw throwable;
                                    }
                                    if (outputStream != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
                                repositoryService.update(false);
                            }
                        }
                    });
                }
                catch (PartInitException partInitException) {
                    Logger.logError((String)("Could not open editor for file " + content));
                }
            }
        }
        return null;
    }
}

