/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.launching;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.modules.unittest.ITestListener;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.tools.AbstractLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class TestSuiteLaunchDelegate
extends AbstractLaunchDelegate {
    private static final String LAUNCH_CONFIGURATION_ID = "org.eclipse.ease.unittest.launchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object resource = ResourceTools.resolveFile((Object)this.getFileLocation(configuration), null, (boolean)true);
        if (resource instanceof IFile) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
                    }
                });
                TestSuite suiteToRun = new TestSuite((IFile)resource);
                IViewPart view = UIModule.showView((String)"org.eclipse.ease.views.unittest");
                if (view instanceof ITestListener) {
                    suiteToRun.addTestListener((ITestListener)view);
                }
                if ("debug".equals(mode)) {
                    suiteToRun.setDebugOptions(launch);
                }
                suiteToRun.run();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected ILaunchConfiguration createLaunchConfiguration(IResource file, String mode) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_ID);
        ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, file.getName());
        configuration.setAttribute("File location", ResourceTools.toAbsoluteLocation((Object)file, null));
        configuration.doSave();
        return configuration;
    }

    protected String getFileLocation(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("File location", "");
    }

    protected String getLaunchConfigurationId() {
        return LAUNCH_CONFIGURATION_ID;
    }
}

