/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.metrics;

import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.repository.logging.ILogListener;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.log.WebSocketLogBridgeServletInternal;
import org.eclipse.dirigible.runtime.memory.MemoryLogCleanupTask;
import org.eclipse.dirigible.runtime.memory.MemoryLogTask;
import org.eclipse.dirigible.runtime.metrics.AccessLogCleanupTask;
import org.eclipse.dirigible.runtime.metrics.AccessLogLocationsSynchronizer;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerLong;
import org.eclipse.dirigible.runtime.task.TaskManagerMedium;
import org.eclipse.dirigible.runtime.task.TaskManagerShort;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class MetricsActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(MetricsActivator.class);
    WebSocketLogBridgeServletInternal webSocketLogBridgeServletInternal;

    public void start(BundleContext context) throws Exception {
        AccessLogLocationsSynchronizer accessLogLocationsSynchronizer = new AccessLogLocationsSynchronizer();
        TaskManagerShort.getInstance().registerRunnableTask((IRunnableTask)accessLogLocationsSynchronizer);
        MemoryLogTask memoryLogTask = new MemoryLogTask();
        TaskManagerMedium.getInstance().registerRunnableTask((IRunnableTask)memoryLogTask);
        AccessLogCleanupTask accessLogCleanupTask = new AccessLogCleanupTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)accessLogCleanupTask);
        MemoryLogCleanupTask memoryLogCleanupTask = new MemoryLogCleanupTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)memoryLogCleanupTask);
        this.setupLogChannel();
    }

    public void stop(BundleContext context) throws Exception {
        this.webSocketLogBridgeServletInternal.closeAll();
        Logger.removeListener((ILogListener)this.webSocketLogBridgeServletInternal);
    }

    protected void setupLogChannel() {
        logger.debug("Setting log channel internal ...");
        this.webSocketLogBridgeServletInternal = new WebSocketLogBridgeServletInternal();
        DirigibleBridge.BRIDGES.put("websocket_log_channel_internal", this.webSocketLogBridgeServletInternal);
        Logger.addListener((ILogListener)this.webSocketLogBridgeServletInternal);
        logger.debug("Log channel internal has been set.");
    }
}

