/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TableColumn;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.ui.common.validation.ValidationStatus;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class JavascriptServiceTemplateModel
extends GenerationModel {
    private static final String ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION = Messages.JavascriptServiceTemplateModel_ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION;
    private static final String TARGET_LOCATION_IS_NOT_ALLOWED = Messages.JavascriptServiceTemplateModel_TARGET_LOCATION_IS_NOT_ALLOWED;
    private static final Logger logger = Logger.getLogger(JavascriptServiceTemplateModel.class);
    private String tableName;
    private String tableType;
    private TableColumn[] tableColumns;
    private boolean columnsInit = false;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public TableColumn[] getTableColumns() {
        if (!this.columnsInit) {
            this.createTableColumns();
        }
        return this.tableColumns;
    }

    public void setTableColumns(TableColumn[] tableColumns) {
        this.tableColumns = tableColumns;
        this.columnsInit = true;
    }

    public IValidationStatus validate() {
        IValidationStatus locationStatus = this.validateLocation();
        if (locationStatus.hasErrors()) {
            return locationStatus;
        }
        IValidationStatus templateStatus = this.validateTemplate();
        if (locationStatus.hasErrors()) {
            return locationStatus;
        }
        return ValidationStatus.getValidationStatus((IValidationStatus)locationStatus, (IValidationStatus)templateStatus);
    }

    public IValidationStatus validateLocation() {
        IValidationStatus status;
        try {
            status = this.validateLocationGeneric();
            if (status.hasErrors()) {
                return status;
            }
            IPath location = new Path(this.getTargetLocation()).append(this.getFileName());
            if (location.toString().indexOf("ScriptingServices") == -1) {
                return ValidationStatus.createError((String)TARGET_LOCATION_IS_NOT_ALLOWED);
            }
        }
        catch (Exception exception) {
            return ValidationStatus.createError((String)"");
        }
        return status;
    }

    public boolean validateTableName() {
        return this.tableName != null;
    }

    private void createTableColumns() {
        if (this.getTableName() == null) {
            return;
        }
        try {
            Connection connection = null;
            try {
                connection = DataSourceFacade.getInstance().getDataSource(CommonParameters.getRequest()).getConnection();
                ArrayList<TableColumn> availableTableColumns = new ArrayList<TableColumn>();
                ResultSet primaryKeys = DBUtils.getPrimaryKeys((Connection)connection, (String)this.getTableName());
                while (primaryKeys.next()) {
                    String columnName = primaryKeys.getString("COLUMN_NAME");
                    TableColumn tableColumn = new TableColumn(columnName, 0, true, true);
                    availableTableColumns.add(tableColumn);
                }
                ResultSet columns = DBUtils.getColumns((Connection)connection, (String)this.getTableName());
                while (columns.next()) {
                    int columnType;
                    String columnName = columns.getString("COLUMN_NAME");
                    TableColumn tableColumn = new TableColumn(columnName, columnType = columns.getInt("DATA_TYPE"), false, true);
                    if (this.exists(availableTableColumns, tableColumn)) continue;
                    availableTableColumns.add(tableColumn);
                }
                this.setTableColumns(availableTableColumns.toArray(new TableColumn[0]));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION, (Throwable)e);
        }
    }

    private boolean exists(List<TableColumn> availableTableColumns, TableColumn tableColumn) {
        if (this.getTableName() == null) {
            return false;
        }
        for (TableColumn tableColumn2 : availableTableColumns) {
            TableColumn tableColumnX = tableColumn2;
            if (!tableColumnX.getName().equals(tableColumn.getName())) continue;
            tableColumnX.setType(tableColumn.getType());
            return true;
        }
        return false;
    }
}

