/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;

public class FileUtils {
    private static final String COULD_NOT_DELETE_TEMP_FILE_S = "Could not delete temp file: %s";
    private static final String COULD_NOT_CREATE_TEMP_DIRECTORY_S = "Could not create temp directory: %s";
    private static final String SLASH = "/";

    public static File createTempDirectory(String directory) throws IOException {
        String suffix = Long.toString(System.nanoTime());
        return FileUtils.createTempDirectory(directory, suffix);
    }

    public static File createTempDirectory(String directory, String suffix) throws IOException {
        File temp = File.createTempFile(directory, suffix);
        if (!temp.delete()) {
            throw new IOException(String.format(COULD_NOT_DELETE_TEMP_FILE_S, temp.getAbsolutePath()));
        }
        if (!temp.mkdir()) {
            throw new IOException(String.format(COULD_NOT_CREATE_TEMP_DIRECTORY_S, temp.getAbsolutePath()));
        }
        return temp;
    }

    public static void copyCollectionToDirectory(ICollection source, File tempDirectory) throws IOException {
        FileUtils.copyCollectionToDirectory(source, tempDirectory, new String[0]);
    }

    public static void copyCollectionToDirectory(ICollection source, File tempDirectory, String ... roots) throws IOException {
        if (!source.exists()) {
            return;
        }
        for (IEntity entity : source.getChildren()) {
            if (entity instanceof ICollection) {
                FileUtils.copyCollectionToDirectory((ICollection)entity, tempDirectory, roots);
            }
            if (!(entity instanceof IResource)) continue;
            String path = entity.getParent().getPath();
            StringBuilder resourceDirectory = new StringBuilder();
            resourceDirectory.append(path);
            resourceDirectory.append(SLASH);
            String directoryPath = resourceDirectory.toString();
            int i = 0;
            while (i < roots.length) {
                if (directoryPath.startsWith(roots[i])) {
                    directoryPath = directoryPath.substring(roots[i].length());
                    break;
                }
                ++i;
            }
            new File(tempDirectory, directoryPath).mkdirs();
            String resourcePath = entity.getPath();
            int i2 = 0;
            while (i2 < roots.length) {
                if (resourcePath.startsWith(roots[i2])) {
                    resourcePath = resourcePath.substring(roots[i2].length());
                    break;
                }
                ++i2;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(((IResource)entity).getContent());
            File outputFile = new File(tempDirectory, resourcePath);
            FileOutputStream out = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            ((InputStream)in).close();
            out.flush();
            out.close();
        }
    }
}

