/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.security;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.security.Messages;
import org.eclipse.dirigible.repository.ext.security.SecurityException;
import org.eclipse.dirigible.repository.ext.security.SecurityLocationMetadata;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class SecurityManager {
    private static final Logger logger = Logger.getLogger(SecurityManager.class);
    private static final String LOCATION_S_AND_S_DOES_NOT_EXIST = Messages.getString("SecurityManager.LOCATION_S_AND_S_DOES_NOT_EXIST");
    private static final String LOCATION_S_DOES_NOT_EXIST = Messages.getString("SecurityManager.LOCATION_S_DOES_NOT_EXIST");
    private static final String DATABASE_ERROR = Messages.getString("SecurityManager.DATABASE_ERROR");
    private static final String EVERYONE_ROLE = "Everyone";
    private static final String INSERT_ACCESS = "/org/eclipse/dirigible/repository/ext/security/sql/insert_access.sql";
    private static final String GET_ROLES_BY_LOCATION = "/org/eclipse/dirigible/repository/ext/security/sql/get_roles_by_location.sql";
    private static final String GET_ROLES_BY_LOCATION_AND_ROLE = "/org/eclipse/dirigible/repository/ext/security/sql/get_roles_by_location_and_role.sql";
    private static final String GET_ACCESS_LOCATIONS = "/org/eclipse/dirigible/repository/ext/security/sql/get_access_locations.sql";
    private static final String REMOVE_BY_LOCATION = "/org/eclipse/dirigible/repository/ext/security/sql/remove_by_location.sql";
    private static final String REMOVE_BY_LOCATION_AND_ROLE = "/org/eclipse/dirigible/repository/ext/security/sql/remove_by_location_and_role.sql";
    private static final String GET_ACCESS_LIST = "/org/eclipse/dirigible/repository/ext/security/sql/get_access_list.sql";
    private static SecurityManager instance;
    private DataSource dataSource;
    private IRepository repository;
    private DBUtils dbUtils;

    public static SecurityManager getInstance(IRepository repository, DataSource dataSource) {
        if (instance == null) {
            instance = new SecurityManager(repository, dataSource);
        }
        return instance;
    }

    public SecurityManager(IRepository repository, DataSource dataSource) {
        this.dataSource = dataSource;
        this.repository = repository;
        this.dbUtils = new DBUtils(dataSource);
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public DBUtils getDBUtils() {
        return this.dbUtils;
    }

    public List<String> getSecuredLocations() throws SecurityException {
        List<String> securedLocations = null;
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                securedLocations = this.getSecuredLocations(connection);
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.error(DATABASE_ERROR, (Throwable)e);
            }
        }
        return securedLocations;
    }

    public List<SecurityLocationMetadata> getAccessList() throws SecurityException {
        List<SecurityLocationMetadata> securedLocations = null;
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                securedLocations = this.getAccessList(connection);
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.error(DATABASE_ERROR, (Throwable)e);
            }
        }
        return securedLocations;
    }

    public void secureLocation(String location, HttpServletRequest request) throws SecurityException {
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                if (!this.isSecuredLocationInternal(connection, location)) {
                    this.insertLocation(connection, location, null, request);
                }
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.error(DATABASE_ERROR, (Throwable)e);
            }
        }
    }

    public void secureLocationWithRole(String location, String roleName, HttpServletRequest request) throws SecurityException {
        Connection connection = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                if (!this.isSecuredLocationInternal(connection, location, roleName)) {
                    this.insertLocation(connection, location, roleName, request);
                }
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.error(DATABASE_ERROR, (Throwable)e);
            }
        }
    }

    public void unsecureLocation(String location) throws SecurityException {
        block11: {
            Connection connection = null;
            try {
                try {
                    connection = this.dataSource.getConnection();
                    if (this.isSecuredLocationInternal(connection, location)) {
                        this.removeLocation(connection, location);
                        break block11;
                    }
                    throw new SecurityException(String.format(LOCATION_S_DOES_NOT_EXIST, location));
                }
                catch (Exception e) {
                    throw new SecurityException(e);
                }
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    logger.error(DATABASE_ERROR, (Throwable)e);
                }
            }
        }
    }

    public void unsecureLocationForRole(String location, String roleName) throws SecurityException {
        block11: {
            Connection connection = null;
            try {
                try {
                    connection = this.dataSource.getConnection();
                    if (this.isSecuredLocationInternal(connection, location, roleName)) {
                        this.removeLocationWithRole(connection, location, roleName);
                        break block11;
                    }
                    throw new SecurityException(String.format(LOCATION_S_AND_S_DOES_NOT_EXIST, location, roleName));
                }
                catch (Exception e) {
                    throw new SecurityException(e);
                }
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    logger.error(DATABASE_ERROR, (Throwable)e);
                }
            }
        }
    }

    private List<String> getSecuredLocations(Connection connection) throws SQLException, IOException {
        ArrayList<String> securedLocations = new ArrayList<String>();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            String script = this.getDBUtils().readScript(connection, GET_ACCESS_LOCATIONS, this.getClass());
            ResultSet resultSet = statement.executeQuery(script);
            while (resultSet.next()) {
                securedLocations.add(resultSet.getString(1));
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return securedLocations;
    }

    private List<SecurityLocationMetadata> getAccessList(Connection connection) throws SQLException, IOException {
        ArrayList<SecurityLocationMetadata> securedLocations = new ArrayList<SecurityLocationMetadata>();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            String script = this.getDBUtils().readScript(connection, GET_ACCESS_LIST, this.getClass());
            ResultSet resultSet = statement.executeQuery(script);
            SecurityLocationMetadata securityLocationMetadata = new SecurityLocationMetadata();
            while (resultSet.next()) {
                String location = resultSet.getString(1);
                if (location == null) continue;
                if (!location.equals(securityLocationMetadata.getLocation())) {
                    if (securityLocationMetadata.getLocation() != null) {
                        securedLocations.add(securityLocationMetadata);
                    }
                    securityLocationMetadata = new SecurityLocationMetadata();
                    securityLocationMetadata.setLocation(location);
                }
                securityLocationMetadata.getRoles().add(resultSet.getString(2));
            }
            securedLocations.add(securityLocationMetadata);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return securedLocations;
    }

    public boolean isSecuredLocation(String location) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.isSecuredLocationInternal(connection, location);
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private boolean isSecuredLocationInternal(Connection connection, String location) throws SQLException, IOException {
        Statement statement = null;
        try {
            String script = this.getDBUtils().readScript(connection, GET_ROLES_BY_LOCATION, this.getClass());
            statement = connection.prepareStatement(script);
            statement.setString(1, String.valueOf(location) + "%");
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                return true;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return false;
    }

    public boolean isSecuredLocation(String location, String roleName) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.isSecuredLocationInternal(connection, location, roleName);
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean isSecuredLocationInternal(Connection connection, String location, String roleName) throws SQLException, IOException {
        Statement statement = null;
        try {
            String script = this.getDBUtils().readScript(connection, GET_ROLES_BY_LOCATION_AND_ROLE, this.getClass());
            statement = connection.prepareStatement(script);
            statement.setString(1, String.valueOf(location) + "%");
            statement.setString(2, roleName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                return true;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return false;
    }

    public List<String> getRolesForLocation(String location) throws SQLException, IOException {
        ArrayList<String> securedRoles = new ArrayList<String>();
        Connection connection = this.dataSource.getConnection();
        try {
            String script = this.getDBUtils().readScript(connection, GET_ROLES_BY_LOCATION, this.getClass());
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(script);
                RepositoryPath path = new RepositoryPath(location);
                int i = path.getSegments().length;
                while (i > 0) {
                    String transitiveLocation = path.constructPath(i);
                    statement.setString(1, transitiveLocation);
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        securedRoles.add(resultSet.getString(1));
                    }
                    if (securedRoles.size() > 0) {
                        break;
                    }
                    --i;
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return securedRoles;
    }

    private void insertLocation(Connection connection, String location, String roleName, HttpServletRequest request) throws SQLException, IOException {
        Statement statement = null;
        try {
            String script = this.getDBUtils().readScript(connection, INSERT_ACCESS, this.getClass());
            statement = connection.prepareStatement(script);
            statement.setString(1, location);
            if (roleName == null) {
                statement.setString(2, EVERYONE_ROLE);
            } else {
                statement.setString(2, roleName);
            }
            statement.setString(3, RequestUtils.getUser(request));
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void removeLocation(Connection connection, String location) throws SQLException, IOException {
        Statement statement = null;
        try {
            String script = this.getDBUtils().readScript(connection, REMOVE_BY_LOCATION, this.getClass());
            statement = connection.prepareStatement(script);
            statement.setString(1, location);
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void removeLocationWithRole(Connection connection, String location, String roleName) throws SQLException, IOException {
        if (roleName == null) {
            this.removeLocation(connection, location);
            return;
        }
        Statement statement = null;
        try {
            String script = this.getDBUtils().readScript(connection, REMOVE_BY_LOCATION_AND_ROLE, this.getClass());
            statement = connection.prepareStatement(script);
            statement.setString(1, location);
            statement.setString(2, roleName);
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

