/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.dao.DBFile;
import org.eclipse.dirigible.repository.db.dao.DBFileVersion;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.db.dao.Messages;
import org.eclipse.dirigible.repository.ext.db.DBUtils;

public class DBMapper {
    private static final String FILE_MODIFIED_AT = "FILE_MODIFIED_AT";
    private static final String FILE_MODIFIED_BY = "FILE_MODIFIED_BY";
    private static final String FILE_CREATED_AT = "FILE_CREATED_AT";
    private static final String FILE_CREATED_BY = "FILE_CREATED_BY";
    private static final String FILE_CONTENT_TYPE = "FILE_CONTENT_TYPE";
    private static final String FILE_TYPE = "FILE_TYPE";
    private static final String FILE_PATH = "FILE_PATH";
    private static final String FILE_NAME = "FILE_NAME";
    static final int OBJECT_TYPE_FOLDER = 0;
    static final int OBJECT_TYPE_DOCUMENT = 1;
    static final int OBJECT_TYPE_BINARY = 2;

    static DBObject dbToObject(DBRepository repository, ResultSet resultSet) throws SQLException, DBBaseException {
        String name = resultSet.getString(FILE_NAME);
        String path = resultSet.getString(FILE_PATH);
        int type = resultSet.getInt(FILE_TYPE);
        String content = resultSet.getString(FILE_CONTENT_TYPE);
        String createdBy = resultSet.getString(FILE_CREATED_BY);
        java.sql.Date createdAt = new java.sql.Date(resultSet.getTimestamp(FILE_CREATED_AT).getTime());
        String modifiedBy = resultSet.getString(FILE_MODIFIED_BY);
        java.sql.Date modifiedAt = new java.sql.Date(resultSet.getTimestamp(FILE_MODIFIED_AT).getTime());
        DBObject dbObject = null;
        if (type == 0) {
            dbObject = new DBFolder(repository);
        } else if (type == 1) {
            dbObject = new DBFile(repository, false, content);
        } else if (type == 2) {
            dbObject = new DBFile(repository, true, content);
        } else {
            throw new DBBaseException(Messages.getString("DBMapper.THE_OBJECT_IS_UNKNOWN"));
        }
        dbObject.setName(name);
        dbObject.setPath(path);
        dbObject.setCreatedBy(createdBy);
        dbObject.setCreatedAt(new Date(createdAt.getTime()));
        dbObject.setModifiedBy(modifiedBy);
        dbObject.setModifiedAt(new Date(modifiedAt.getTime()));
        return dbObject;
    }

    static byte[] dbToData(ResultSet resultSet) throws SQLException {
        return DBUtils.dbToData((ResultSet)resultSet);
    }

    public static byte[] dbToDataBinary(Connection connection, ResultSet resultSet, String columnName) throws SQLException, IOException {
        return DBUtils.dbToDataBinary((Connection)connection, (ResultSet)resultSet, (String)columnName);
    }

    public static DBFileVersion dbToFileVersion(Connection connection, DBRepository repository, ResultSet resultSet) throws SQLException, DBBaseException, IOException {
        String path = resultSet.getString("FV_FILE_PATH");
        int version = resultSet.getInt("FV_VERSION");
        byte[] bytes = DBMapper.dbToDataBinary(connection, resultSet, "FV_CONTENT");
        int type = resultSet.getInt("FV_TYPE");
        String content = resultSet.getString("FV_CONTENT_TYPE");
        String createdBy = resultSet.getString("FV_CREATED_BY");
        java.sql.Date createdAt = new java.sql.Date(resultSet.getTimestamp("FV_CREATED_AT").getTime());
        DBFileVersion dbFileVersion = new DBFileVersion(repository, type == 2, content, version, bytes);
        dbFileVersion.setPath(path);
        dbFileVersion.setCreatedBy(createdBy);
        dbFileVersion.setCreatedAt(createdAt);
        return dbFileVersion;
    }
}

