/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.content.Messages;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public class ContentBaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 6468050094756163896L;
    static final String COULD_NOT_INITIALIZE_REPOSITORY = Messages.getString("ContentInitializerServlet.COULD_NOT_INITIALIZE_REPOSITORY");
    static final String REPOSITORY_ATTRIBUTE = "repository-instance";
    private static final Logger logger = Logger.getLogger(ContentBaseServlet.class);
    static final String SYSTEM_USER = "SYSTEM";

    private IRepository initRepository(HttpServletRequest request) throws ServletException {
        try {
            IRepository repository = RepositoryFacade.getInstance().getRepository(request);
            return repository;
        }
        catch (Exception ex) {
            logger.error("Exception in initRepository(): " + ex.getMessage(), (Throwable)ex);
            throw new ServletException(COULD_NOT_INITIALIZE_REPOSITORY, (Throwable)ex);
        }
    }

    protected IRepository getRepository(HttpServletRequest request) throws IOException {
        try {
            return this.initRepository(request);
        }
        catch (ServletException e) {
            logger.error("Exception in getRepository(): " + e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }
}

