/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.tc.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.tc.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.tc.wizard.TestCaseTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.tc.wizard.TestCaseTemplateModel;
import org.eclipse.dirigible.ide.template.ui.tc.wizard.TestCaseTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.tc.wizard.TestCaseTemplateTypePage;
import org.eclipse.jface.wizard.IWizardPage;

public class TestCaseTemplateWizard
extends TemplateWizard {
    private static final String CREATE_TEST_CASE = Messages.TestCaseTemplateWizard_CREATE_TEST_CASE;
    private final TestCaseTemplateModel model;
    private final TestCaseTemplateTypePage typesPage;
    private final TestCaseTemplateTargetLocationPage targetLocationPage;

    public TestCaseTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_TEST_CASE);
        this.model = new TestCaseTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new TestCaseTemplateTypePage(this.model);
        this.targetLocationPage = new TestCaseTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        TestCaseTemplateGenerator generator = new TestCaseTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

