/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.scripts.publish;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.repository.api.ICollection;

public class ScriptsPublisher
extends AbstractPublisher
implements IPublisher {
    public static final List<String> RECOGNIZED_EXTENSIONS = new ArrayList<String>();
    public static final Map<String, String> PUBLISH_CONTAINERS = new HashMap<String, String>();
    public static final Map<String, String> ACTIVATE_CONTAINERS = new HashMap<String, String>();

    static {
        RECOGNIZED_EXTENSIONS.add("js");
        RECOGNIZED_EXTENSIONS.add("rb");
        RECOGNIZED_EXTENSIONS.add("groovy");
        RECOGNIZED_EXTENSIONS.add("java");
        RECOGNIZED_EXTENSIONS.add("command");
        RECOGNIZED_EXTENSIONS.add("sql");
        PUBLISH_CONTAINERS.put("js", "/js");
        PUBLISH_CONTAINERS.put("rb", "/rb");
        PUBLISH_CONTAINERS.put("groovy", "/groovy");
        PUBLISH_CONTAINERS.put("java", "/java");
        PUBLISH_CONTAINERS.put("command", "/command");
        PUBLISH_CONTAINERS.put("sql", "/sql");
        ACTIVATE_CONTAINERS.put("js", "/js-sandbox");
        ACTIVATE_CONTAINERS.put("rb", "/rb-sandbox");
        ACTIVATE_CONTAINERS.put("groovy", "/groovy-sandbox");
        ACTIVATE_CONTAINERS.put("java", "/java-sandbox");
        ACTIVATE_CONTAINERS.put("command", "/command-sandbox");
        ACTIVATE_CONTAINERS.put("sql", "/sql-sandbox");
    }

    public void publish(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation());
            IFolder sourceFolder = this.getSourceFolder(project, "ScriptingServices");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(CommonParameters.getScriptingContentSandbox());
            IFolder sourceFolder = this.getSourceFolder(project, "ScriptingServices");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getFolderType() {
        return "ScriptingServices";
    }

    public boolean recognizedFile(IFile file) {
        String ext;
        return this.checkFolderType(file) && RECOGNIZED_EXTENSIONS.contains(ext = file.getFileExtension());
    }

    public String getPublishedContainerMapping(IFile file) {
        String ext = file.getFileExtension();
        return PUBLISH_CONTAINERS.get(ext);
    }

    public String getActivatedContainerMapping(IFile file) {
        String ext = file.getFileExtension();
        return ACTIVATE_CONTAINERS.get(ext);
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getSandboxLocation() {
        return CommonParameters.getScriptingContentSandbox();
    }

    public String getDebugEndpoint(IFile file) {
        if ("js".equals(file.getFileExtension())) {
            return String.valueOf(CommonParameters.getServicesUrl()) + "/js-debug" + this.generatePublishedPath(file);
        }
        return null;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/ScriptingServices";
    }
}

