/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.remote;

import java.util.List;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.remote.DeferredRemoteObject;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectRegistry;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.remote.OperationHandler;

public class RemoteObjectLifeCycleAdapter {
    public static void readData(ClientMessage message) {
        RemoteObjectRegistry registry = RemoteObjectRegistry.getInstance();
        for (RemoteObjectImpl remoteObject : registry.getRemoteObjects()) {
            if (!(remoteObject instanceof DeferredRemoteObject)) continue;
            RemoteObjectLifeCycleAdapter.dispatchOperations(message, remoteObject);
        }
    }

    public static void render() {
        RemoteObjectRegistry registry = RemoteObjectRegistry.getInstance();
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        for (RemoteObjectImpl remoteObject : registry.getRemoteObjects()) {
            if (remoteObject instanceof DeferredRemoteObject) {
                ((DeferredRemoteObject)remoteObject).render(writer);
            }
            if (!remoteObject.isDestroyed()) continue;
            RemoteObjectRegistry.getInstance().remove(remoteObject);
        }
    }

    private static void dispatchOperations(ClientMessage message, RemoteObjectImpl remoteObject) {
        List<Operation> operations = message.getAllOperationsFor(remoteObject.getId());
        if (!operations.isEmpty()) {
            OperationHandler handler = RemoteObjectLifeCycleAdapter.getHandler(remoteObject);
            for (Operation operation : operations) {
                RemoteObjectLifeCycleAdapter.dispatchOperation(handler, operation);
            }
        }
    }

    private static OperationHandler getHandler(RemoteObjectImpl remoteObject) {
        OperationHandler handler = remoteObject.getHandler();
        if (handler == null) {
            String message = "No operation handler registered for remote object: " + remoteObject.getId();
            throw new UnsupportedOperationException(message);
        }
        return handler;
    }

    private static void dispatchOperation(OperationHandler handler, Operation operation) {
        if (operation instanceof Operation.SetOperation) {
            handler.handleSet(((Operation.SetOperation)operation).getProperties());
        } else if (operation instanceof Operation.CallOperation) {
            Operation.CallOperation callOperation = (Operation.CallOperation)operation;
            handler.handleCall(callOperation.getMethodName(), callOperation.getParameters());
        } else if (operation instanceof Operation.NotifyOperation) {
            Operation.NotifyOperation notifyOperation = (Operation.NotifyOperation)operation;
            RemoteObjectLifeCycleAdapter.scheduleHandleNotify(handler, notifyOperation.getEventName(), notifyOperation.getProperties());
        }
    }

    private static void scheduleHandleNotify(final OperationHandler handler, final String event, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                handler.handleNotify(event, properties);
            }
        });
    }
}

