/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.job;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CronJob
implements Job {
    private static final Logger logger = Logger.getLogger(CronJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Starting Job...");
        String instName = context.getJobDetail().getName();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String jobType = dataMap.getString("type");
        String jobModule = dataMap.getString("module");
        logger.debug(String.format("Job processing name: %s, type: %s, module: %s ...", instName, jobType, jobModule));
        HashMap<Object, Object> executionContext = new HashMap<Object, Object>();
        Object inputOutput = null;
        try {
            inputOutput = CronJob.executeByEngineType(null, null, jobModule, executionContext, instName, inputOutput, jobType);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug(String.format("Job name: %s, type: %s, module: %s finished.", instName, jobType, jobModule));
    }

    public static Object executeByEngineType(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext, String jobName, Object inputOutput, String scriptType) throws IOException {
        Set types = EngineUtils.getTypes();
        for (String type : types) {
            if (type == null || !type.equalsIgnoreCase(scriptType)) continue;
            IScriptExecutor scriptExecutor = EngineUtils.createExecutor((String)type, (HttpServletRequest)request);
            scriptExecutor.executeServiceModule(request, response, module, executionContext);
        }
        return inputOutput;
    }
}

