/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.ext.fs.FileSystemUtils;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalFile;
import org.eclipse.dirigible.repository.local.LocalFileVersion;
import org.eclipse.dirigible.repository.local.LocalFolder;
import org.eclipse.dirigible.repository.local.LocalObject;
import org.eclipse.dirigible.repository.local.LocalResourceVersion;
import org.eclipse.dirigible.repository.local.LocalWorkspaceMapper;
import org.eclipse.dirigible.repository.logging.Logger;

public class LocalRepositoryDAO {
    private static final String LAST = "last";
    private static final String MODIFIED_AT = "modifiedAt";
    private static final String MODIFIED_BY = "modifiedBy";
    private static final String CREATED_AT = "createdAt";
    private static final String CREATED_BY = "createdBy";
    private static final Logger logger = Logger.getLogger(LocalRepositoryDAO.class);
    static final int OBJECT_TYPE_FOLDER = 0;
    static final int OBJECT_TYPE_DOCUMENT = 1;
    static final int OBJECT_TYPE_BINARY = 2;
    private FileSystemRepository repository;

    LocalRepositoryDAO(FileSystemRepository repository) {
        this.repository = repository;
    }

    public FileSystemRepository getRepository() {
        return this.repository;
    }

    public void createFile(String path, byte[] content, boolean isBinary, String contentType) throws LocalBaseException {
        try {
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
            FileSystemUtils.saveFile((String)workspacePath, (byte[])content);
            this.createVersion(workspacePath, content);
            this.createInfo(workspacePath);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    private void createVersion(String workspacePath, byte[] content) throws FileNotFoundException, IOException {
        String versionsPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getVersionsPath());
        if (FileSystemUtils.directoryExists((String)versionsPath)) {
            String versionsLastPath = String.valueOf(versionsPath) + File.separator + LAST;
            byte[] bytes = FileSystemUtils.loadFile((String)versionsLastPath);
            if (bytes != null) {
                try {
                    Integer index = Integer.parseInt(new String(bytes));
                    index = index + 1;
                    FileSystemUtils.saveFile((String)(String.valueOf(versionsPath) + File.separator + index), (byte[])content);
                    FileSystemUtils.saveFile((String)versionsLastPath, (byte[])index.toString().getBytes());
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error(String.format("Invalid versions file: %s", versionsLastPath));
                    this.createInitialVersion(content, versionsPath);
                }
            }
        } else {
            this.createInitialVersion(content, versionsPath);
        }
    }

    private void createInitialVersion(byte[] content, String versionsPath) throws FileNotFoundException, IOException {
        FileSystemUtils.saveFile((String)(String.valueOf(versionsPath) + File.separator + "1"), (byte[])content);
        FileSystemUtils.saveFile((String)(String.valueOf(versionsPath) + File.separator + LAST), (byte[])"1".getBytes());
    }

    private void createInfo(String workspacePath) throws FileNotFoundException, IOException {
        String infoPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getInfoPath());
        if (FileSystemUtils.fileExists((String)infoPath)) {
            byte[] bytes = FileSystemUtils.loadFile((String)infoPath);
            if (bytes != null) {
                Properties info = new Properties();
                info.load(new ByteArrayInputStream(bytes));
                info.setProperty(MODIFIED_BY, this.getRepository().getUser());
                info.setProperty(MODIFIED_AT, String.valueOf(new Date().getTime()));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                info.store(out, "");
                FileSystemUtils.saveFile((String)infoPath, (byte[])out.toByteArray());
            }
        } else {
            this.createInitialInfo(infoPath);
        }
    }

    private void createInitialInfo(String infoPath) throws IOException {
        Properties info = new Properties();
        info.setProperty(CREATED_BY, this.getRepository().getUser());
        info.setProperty(CREATED_AT, String.valueOf(new Date().getTime()));
        info.setProperty(MODIFIED_BY, this.getRepository().getUser());
        info.setProperty(MODIFIED_AT, String.valueOf(new Date().getTime()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        info.store(out, "");
        FileSystemUtils.saveFile((String)infoPath, (byte[])out.toByteArray());
    }

    private void removeVersions(String workspacePath) throws FileNotFoundException, IOException {
        String versionsPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getVersionsPath());
        if (FileSystemUtils.directoryExists((String)versionsPath)) {
            FileSystemUtils.removeFile((String)versionsPath);
        }
    }

    private void removeInfo(String workspacePath) throws FileNotFoundException, IOException {
        String infoPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getInfoPath());
        if (FileSystemUtils.fileExists((String)infoPath)) {
            FileSystemUtils.removeFile((String)infoPath);
        }
    }

    public void checkInitialized() {
    }

    public void setFileContent(LocalFile localFile, byte[] content) {
        try {
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), localFile.getPath());
            FileSystemUtils.saveFile((String)workspacePath, (byte[])content);
            this.createVersion(workspacePath, content);
            this.createInfo(workspacePath);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public byte[] getFileContent(LocalFile localFile) {
        try {
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), localFile.getPath());
            return FileSystemUtils.loadFile((String)workspacePath);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public void renameFile(String path, String newPath) {
        try {
            String workspacePathOld = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
            String workspacePathNew = LocalWorkspaceMapper.getMappedName(this.getRepository(), newPath);
            FileSystemUtils.moveFile((String)workspacePathOld, (String)workspacePathNew);
            byte[] content = FileSystemUtils.loadFile((String)workspacePathNew);
            if (content != null) {
                this.createVersion(workspacePathNew, content);
                this.createInfo(workspacePathNew);
                this.removeVersions(workspacePathOld);
                this.removeInfo(workspacePathOld);
            }
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public void removeFileByPath(String path) {
        try {
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
            FileSystemUtils.removeFile((String)workspacePath);
            this.removeVersions(workspacePath);
            this.removeInfo(workspacePath);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public void removeFolderByPath(String path) {
        try {
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
            FileSystemUtils.removeFile((String)workspacePath);
            this.removeVersions(workspacePath);
            this.removeInfo(workspacePath);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public void createFolder(String normalizePath) {
        try {
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), normalizePath);
            FileSystemUtils.createFolder((String)workspacePath);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public void renameFolder(String path, String newPath) {
        try {
            String workspacePathOld = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
            String workspacePathNew = LocalWorkspaceMapper.getMappedName(this.getRepository(), newPath);
            FileSystemUtils.moveFile((String)workspacePathOld, (String)workspacePathNew);
            this.removeVersions(workspacePathNew);
            this.removeInfo(workspacePathNew);
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
    }

    public LocalObject getObjectByPath(String path) {
        byte[] bytes;
        File objectFile;
        String workspacePath;
        LocalObject localObject;
        block8: {
            localObject = null;
            try {
                workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
                objectFile = new File(workspacePath);
                if (objectFile.exists() || !ContentTypeHelper.getExtension((String)workspacePath).isEmpty() || workspacePath.endsWith(".")) break block8;
                return null;
            }
            catch (IOException e) {
                throw new LocalBaseException(e);
            }
        }
        if (objectFile.isFile()) {
            String contentType = ContentTypeHelper.getContentType((String)FileSystemUtils.getExtension((String)workspacePath));
            localObject = new LocalFile(this.repository, ContentTypeHelper.isBinary((String)contentType), contentType);
        } else {
            localObject = new LocalFolder(this.repository);
        }
        localObject.setName(objectFile.getName());
        localObject.setPath(workspacePath);
        String infoPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getInfoPath());
        if (FileSystemUtils.fileExists((String)infoPath) && (bytes = FileSystemUtils.loadFile((String)infoPath)) != null) {
            Properties info = new Properties();
            info.load(new ByteArrayInputStream(bytes));
            localObject.setCreatedBy(info.getProperty(CREATED_BY));
            String prop = info.getProperty(CREATED_AT);
            if (prop != null) {
                localObject.setCreatedAt(new Date(Long.parseLong(prop)));
            }
            localObject.setModifiedBy(info.getProperty(MODIFIED_BY));
            prop = info.getProperty(MODIFIED_AT);
            if (prop != null) {
                localObject.setModifiedAt(new Date(Long.parseLong(prop)));
            }
        }
        return localObject;
    }

    public List<LocalObject> getChildrenByFolder(String path) {
        ArrayList<LocalObject> localObjects = new ArrayList<LocalObject>();
        try {
            File[] children;
            String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
            File objectFile = new File(workspacePath);
            if (objectFile.isDirectory() && (children = objectFile.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    localObjects.add(this.getObjectByPath(file.getCanonicalPath()));
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            throw new LocalBaseException(e);
        }
        return localObjects;
    }

    public List<IResourceVersion> getResourceVersionsByPath(String path) throws IOException {
        File[] children;
        ArrayList<IResourceVersion> versions = new ArrayList<IResourceVersion>();
        String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
        String versionsPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getVersionsPath());
        File versionsDir = new File(versionsPath);
        if (versionsDir.isDirectory() && (children = versionsDir.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!LAST.equals(file.getName())) {
                    int version = Integer.parseInt(file.getName());
                    LocalResourceVersion localResourceVersion = new LocalResourceVersion(this.getRepository(), new RepositoryPath(path), version);
                    versions.add(localResourceVersion);
                }
                ++n2;
            }
            Collections.sort(versions);
        }
        return versions;
    }

    public LocalFileVersion getFileVersionByPath(String path, int version) throws FileNotFoundException, IOException {
        String workspacePath = LocalWorkspaceMapper.getMappedName(this.getRepository(), path);
        return this.getLocalFileVersionByPath(version, workspacePath);
    }

    private LocalFileVersion getLocalFileVersionByPath(int version, String workspacePath) throws FileNotFoundException, IOException {
        byte[] bytes;
        String versionsPath = workspacePath.replace(this.getRepository().getRepositoryPath(), this.getRepository().getVersionsPath());
        String versionPath = String.valueOf(versionsPath) + File.separator + version;
        if (FileSystemUtils.fileExists((String)versionPath) && (bytes = FileSystemUtils.loadFile((String)versionPath)) != null) {
            String ext = FilenameUtils.getExtension((String)workspacePath);
            String contentType = ContentTypeHelper.getContentType((String)ext);
            boolean isBinary = ContentTypeHelper.isBinary((String)contentType);
            LocalFileVersion localFileVersion = new LocalFileVersion(this.getRepository(), isBinary, contentType, version, bytes);
            localFileVersion.setCreatedBy(FileSystemUtils.getOwner((String)workspacePath));
            localFileVersion.setCreatedAt(FileSystemUtils.getModifiedAt((String)workspacePath));
            return localFileVersion;
        }
        return null;
    }
}

