/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBCollection;
import org.eclipse.dirigible.repository.db.DBResource;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBMapper;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.db.dao.DBObjectDAO;
import org.eclipse.dirigible.repository.db.dao.DBRepositoryDAO;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBSearchDAO
extends DBObjectDAO {
    private static Logger logger = Logger.getLogger(DBSearchDAO.class);

    DBSearchDAO(DBRepositoryDAO dbRepositoryDAO) {
        super(dbRepositoryDAO);
    }

    List<IEntity> searchName(String parameter, boolean caseInsensitive) throws DBBaseException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("%" + this.getParameter(parameter, caseInsensitive) + "%");
        return this.search(parameters, this.getSearchNameSQLFile(caseInsensitive));
    }

    List<IEntity> searchName(String root, String parameter, boolean caseInsensitive) throws DBBaseException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(String.valueOf(root) + "%");
        parameters.add("%" + this.getParameter(parameter, caseInsensitive));
        return this.search(parameters, this.getSearchNameUnderRootSQLFile(caseInsensitive));
    }

    List<IEntity> searchPath(String parameter, boolean caseInsensitive) throws DBBaseException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("%" + this.getParameter(parameter, caseInsensitive) + "%");
        return this.search(parameters, this.getSearchNameSQLFile(caseInsensitive));
    }

    private String getParameter(String parameter, boolean caseInsensitive) {
        return caseInsensitive ? parameter.toUpperCase() : parameter;
    }

    private String getSearchNameSQLFile(boolean caseInsensitive) {
        return caseInsensitive ? "/org/eclipse/dirigible/repository/db/sql/search_name.sql" : "/org/eclipse/dirigible/repository/db/sql/search_name_sense.sql";
    }

    private String getSearchNameUnderRootSQLFile(boolean caseInsensitive) {
        return caseInsensitive ? "/org/eclipse/dirigible/repository/db/sql/search_name_under_root.sql" : "/org/eclipse/dirigible/repository/db/sql/search_name_under_root_sense.sql";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IEntity> search(List<String> parameters, String sqlFile) throws DBBaseException {
        List<IEntity> list;
        logger.debug("entering searchInPath");
        this.checkInitialized();
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getRepository().getDbUtils().getConnection();
            String script = this.getRepository().getDbUtils().readScript(connection, sqlFile, this.getClass());
            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
            int i = 0;
            while (true) {
                if (i >= parameters.size()) {
                    list = this.getEntityList(preparedStatement);
                    break;
                }
                preparedStatement.setString(i + 1, parameters.get(i));
                ++i;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBBaseException(e);
                catch (IOException e2) {
                    throw new DBBaseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                logger.debug("exiting searchInPath");
                throw throwable;
            }
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting searchInPath");
        return list;
    }

    private List<IEntity> getEntityList(PreparedStatement preparedStatement) throws SQLException {
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            DBObject dbObject = DBMapper.dbToObject(this.getRepository(), resultSet);
            if (dbObject instanceof DBFolder) {
                DBCollection collection = new DBCollection(this.getRepository(), new RepositoryPath(dbObject.getPath()));
                result.add(collection);
                continue;
            }
            DBResource resource = new DBResource(this.getRepository(), new RepositoryPath(dbObject.getPath()));
            result.add(resource);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IEntity> searchInPathAndText(String parameter, boolean caseInsensitive) throws DBBaseException {
        ArrayList<IEntity> arrayList;
        logger.debug("entering searchInPathAndText");
        this.checkInitialized();
        if (parameter == null) {
            return null;
        }
        parameter = "%" + parameter + "%";
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            String script;
            connection = this.getRepository().getDbUtils().getConnection();
            if (caseInsensitive) {
                parameter = parameter.toUpperCase();
                script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/search_text.sql", this.getClass());
            } else {
                script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/search_text_sense.sql", this.getClass());
            }
            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
            preparedStatement.setString(1, parameter);
            preparedStatement.setString(2, parameter);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (true) {
                if (!resultSet.next()) {
                    arrayList = result;
                    break;
                }
                String path = resultSet.getString(1);
                IResource resource = this.getRepository().getResource(path);
                result.add((IEntity)resource);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBBaseException(e);
                catch (IOException e2) {
                    throw new DBBaseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                logger.debug("exiting searchInPathAndText");
                throw throwable;
            }
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting searchInPathAndText");
        return arrayList;
    }
}

