/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.JavaScriptServlet;
import org.eclipse.dirigible.runtime.js.debug.JavaScriptDebuggingExecutor;

public class JavaScriptDebugServlet
extends JavaScriptServlet {
    private static final long serialVersionUID = -9115022531455267478L;
    private static final Logger logger = Logger.getLogger(JavaScriptDebugServlet.class);

    @Override
    public JavaScriptDebuggingExecutor createExecutor(HttpServletRequest request) throws IOException {
        logger.debug("entering JavaScriptDebugServlet.createExecutor()");
        DebugModel debugModel = (DebugModel)request.getSession(true).getAttribute("debug.model");
        if (debugModel == null) {
            String error = "Debug model is not present in the session";
            logger.error(error);
            throw new IOException(error);
        }
        String rootPath = this.getScriptingRegistryPath(request);
        logger.debug("rootPath=" + rootPath);
        JavaScriptDebuggingExecutor executor = new JavaScriptDebuggingExecutor(this.getRepository(request), rootPath, "/db/dirigible/registry/public/ScriptingServices", debugModel);
        logger.debug("exiting JavaScriptDebugServlet.createExecutor()");
        return executor;
    }
}

