/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.dao.DBFileVersion;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBMapper;
import org.eclipse.dirigible.repository.db.dao.DBRepositoryDAO;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBFileVersionDAO {
    private static Logger logger = Logger.getLogger(DBFileVersionDAO.class);
    private DBRepositoryDAO dbRepositoryDAO;

    DBFileVersionDAO(DBRepositoryDAO dbRepositoryDAO) {
        this.dbRepositoryDAO = dbRepositoryDAO;
    }

    public DBRepositoryDAO getDbRepositoryDAO() {
        return this.dbRepositoryDAO;
    }

    protected DBRepository getRepository() {
        return this.dbRepositoryDAO.getRepository();
    }

    protected void checkInitialized() {
        this.dbRepositoryDAO.checkInitialized();
    }

    public DBFileVersion getFileVersionByPath(String path, int version) throws DBBaseException {
        logger.debug("entering getFileVersionByPath");
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        DBFileVersion dbFileVersion = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_file_version_by_path.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, path);
                preparedStatement.setInt(2, version);
                ResultSet resultSet = null;
                try {
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        dbFileVersion = DBMapper.dbToFileVersion(connection, this.getRepository(), resultSet);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting getFileVersionByPath");
        return dbFileVersion;
    }

    private int insertFileVersion(String path, byte[] bytes, String contentType, String createdBy, int type) throws DBBaseException {
        logger.debug("entering insertFileVersion");
        this.checkInitialized();
        int version = this.getNextVersion(path);
        if (bytes == null) {
            bytes = new byte[]{};
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/insert_file_version.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                int i = 0;
                preparedStatement.setString(++i, path);
                preparedStatement.setInt(++i, version);
                preparedStatement.setBinaryStream(++i, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                preparedStatement.setInt(++i, type);
                preparedStatement.setString(++i, contentType);
                preparedStatement.setString(++i, createdBy);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting insertFileVersion");
        return version;
    }

    private int getNextVersion(String path) {
        logger.debug("entering getNextVersion");
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return 0;
        }
        int version = 0;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_next_file_version_by_path.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, path);
                ResultSet resultSet = null;
                try {
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        version = resultSet.getInt(1);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting getNextVersion");
        return version + 1;
    }

    public DBFileVersion createFileVersion(String path, byte[] bytes, boolean isBinary, String contentType) throws DBBaseException {
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        if (isBinary) {
            return null;
        }
        String createdBy = this.getRepository().getUser();
        DBFileVersion fileVersion = null;
        String collectionPath = path.substring(0, path.lastIndexOf("/"));
        DBFolder parent = this.getDbRepositoryDAO().getDbFolderDAO().createFolder(collectionPath);
        if (parent != null) {
            int version = this.insertFileVersion(path, bytes, contentType, createdBy, isBinary ? 2 : 1);
            fileVersion = this.getFileVersionByPath(path, version);
        }
        return fileVersion;
    }

    public List<DBFileVersion> getFileVersionsByPath(String path) {
        logger.debug("entering getFileVersionsByPath");
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        ArrayList<DBFileVersion> dbFileVersions = new ArrayList<DBFileVersion>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_file_versions_by_path.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, path);
                ResultSet resultSet = null;
                try {
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        DBFileVersion dbFileVersion = DBMapper.dbToFileVersion(connection, this.getRepository(), resultSet);
                        dbFileVersions.add(dbFileVersion);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting getFileVersionsByPath");
        return dbFileVersions;
    }

    public void removeAllFileVersions(String path) throws DBBaseException {
        logger.debug("entering removeAllFileVersions");
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_all_file_versions_by_path.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                int i = 0;
                preparedStatement.setString(++i, path);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting removeAllFileVersions");
    }

    public void removeAllFileVersionsBeforeDate(Date date) throws DBBaseException {
        logger.debug("entering removeAllFileVersionsBeforeDate");
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_all_file_versions_before_date.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                int i = 0;
                preparedStatement.setDate(++i, new java.sql.Date(date.getTime()));
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting removeAllFileVersionsBeforeDate");
    }
}

