/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.viewer;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.workspace.ui.viewer.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class WorkspaceContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = -2997727533953364324L;
    private static final String COULD_NOT_DETERMINE_IF_CONTAINER_HAS_CHILDREN = Messages.WorkspaceContentProvider_COULD_NOT_DETERMINE_IF_CONTAINER_HAS_CHILDREN;
    private static final String COULD_NOT_GET_THE_CONTAINER_S_CHILDREN = Messages.WorkspaceContentProvider_COULD_NOT_GET_THE_CONTAINER_S_CHILDREN;
    private static final Logger logger = Logger.getLogger((String)WorkspaceContentProvider.class.getCanonicalName());

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            try {
                return container.members();
            }
            catch (CoreException ex) {
                logger.error(COULD_NOT_GET_THE_CONTAINER_S_CHILDREN);
                logger.error(WorkspaceContentProvider.class.getCanonicalName(), (Throwable)ex);
                return new Object[0];
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            try {
                return container.members().length > 0;
            }
            catch (CoreException ex) {
                logger.error(COULD_NOT_DETERMINE_IF_CONTAINER_HAS_CHILDREN);
                logger.error(WorkspaceContentProvider.class.getCanonicalName(), (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

