/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class ListBlock
extends NestableBlock {
    private static final Pattern itemStartPattern = Pattern.compile(" {0,3}(?:([\\*\\+\\-])|([0-9]+\\.))\\s+(.+?)");
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        Matcher matcher = itemStartPattern.matcher(line.substring(lineOffset));
        return matcher.matches();
    }

    protected int processLineContent(String line, int offset) {
        String text = line.substring(offset);
        Matcher itemStartMatcher = itemStartPattern.matcher(text);
        if (itemStartMatcher.matches()) {
            if (this.blockLineCount == 0) {
                DocumentBuilder.BlockType blockType = itemStartMatcher.group(1) != null ? DocumentBuilder.BlockType.BULLETED_LIST : DocumentBuilder.BlockType.NUMERIC_LIST;
                this.builder.beginBlock(blockType, new Attributes());
            } else {
                this.builder.endBlock();
            }
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
            offset += itemStartMatcher.start(3);
        } else if (!text.trim().isEmpty()) {
            this.builder.characters("\n");
        } else {
            this.setClosed(true);
            return offset;
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        ++this.blockLineCount;
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

