/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile;

import java.io.File;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ExportProfilesDialog;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionPageHelper;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.IBrowseButtonHost;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.MenuButtonProvider;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.ProfileStoreBrowseButton;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.filter.NewProfileAction;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.profile.ProfileFileExtension;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProfileStoreCreationDialog
extends ExportProfilesDialog
implements IBrowseButtonHost {
    private static final String EXT_SEPARATOR = ".";
    private CheckboxTableViewer m_profilesViewer;
    private ProfileStoreBrowseButton m_browseButton;
    private IConnectionProfile m_preSelectProfile;
    private ResourceIdentifiers m_resourceIdentifiers = null;
    private boolean m_isProfileStorePathRelative = false;

    public ProfileStoreCreationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(super.getShellStyle() | 0x8000);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.profileStoreCreationDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.createParentDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.makeColumnsEqualWidth = false;
        groupGridLayout.numColumns = 3;
        Group group = this.createProfileSelectionGroup(container, (Layout)groupGridLayout);
        group.setText(Messages.profileStoreCreationDialog_grouptext);
        this.m_profilesViewer = this.setupCheckboxTableViewer((Composite)group);
        this.setCheckedProfile();
        GridData selectAllButtonData = new GridData();
        selectAllButtonData.horizontalAlignment = 16384;
        Button button = this.createSelectAllButton((Composite)group, selectAllButtonData);
        selectAllButtonData.widthHint = ProfileSelectionPageHelper.computeButtonWidth(button);
        GridData deselectAllButtonData = new GridData();
        deselectAllButtonData.horizontalAlignment = 16384;
        button = this.createDeselectAllButton((Composite)group, deselectAllButtonData);
        deselectAllButtonData.widthHint = ProfileSelectionPageHelper.computeButtonWidth(button);
        Button newButton = new Button((Composite)group, 8);
        newButton.setText(Messages.profileStoreCreationDialog_button_new);
        newButton.setToolTipText(Messages.profileStoreCreationDialog_newbutton_tooltiptext);
        GridData newButtonData = new GridData();
        newButtonData.horizontalAlignment = 131072;
        newButtonData.verticalAlignment = 128;
        newButtonData.widthHint = ProfileSelectionPageHelper.computeButtonWidth(newButton);
        newButton.setLayoutData((Object)newButtonData);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleNewProfile();
            }

            private void handleNewProfile() {
                NewProfileAction newProfileAction = new NewProfileAction(ProfileStoreCreationDialog.this.getShell());
                newProfileAction.run();
                ProfileStoreCreationDialog.this.m_profilesViewer.refresh();
            }
        });
        this.createVerticalSpacingLabel(container);
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 410;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createFilePathLabel(composite, null);
        GridData data = new GridData(768);
        data.widthHint = 290;
        this.setupFilePathText(composite, data);
        MenuButtonProvider provider = new MenuButtonProvider(true);
        this.m_browseButton = new ProfileStoreBrowseButton(composite, 8, provider, this);
        GridData data2 = new GridData();
        data2.widthHint = this.m_browseButton.computeButtonWidth();
        this.m_browseButton.setLayoutData(data2);
        if (this.m_resourceIdentifiers != null) {
            File resourceBase = new File(this.m_resourceIdentifiers.getApplResourceBaseURI());
            this.m_browseButton.getMenuButtonProvider().setProperty("ResourceFileDIR", resourceBase);
        }
        this.m_browseButton.getMenuButtonProvider().setProperty("IsCreateProfile", Boolean.TRUE);
        this.m_browseButton.refreshMenuItems();
        this.setupEncryptContentCheckbox(container);
        this.setupHelp((Control)this.getShell());
        return container;
    }

    public void setPreSelectedProfile(IConnectionProfile profile) {
        this.m_preSelectProfile = profile;
    }

    private void setCheckedProfile() {
        if (this.m_profilesViewer == null || this.m_preSelectProfile == null) {
            return;
        }
        this.m_profilesViewer.setChecked((Object)this.m_preSelectProfile, true);
    }

    void setHostResourceIdentifiers(ResourceIdentifiers resourceIdentifiers) {
        this.m_resourceIdentifiers = resourceIdentifiers;
    }

    protected String getFilePathText() {
        String profileStorePath = super.getFilePathText();
        if (profileStorePath == null || profileStorePath.trim().length() == 0) {
            this.m_isProfileStorePathRelative = false;
            return profileStorePath;
        }
        String trimmedPath = profileStorePath.trim();
        this.m_isProfileStorePathRelative = !new File(trimmedPath).isAbsolute();
        String resolvedProfilePath = DesignUtil.resolveToApplResourcePath((String)trimmedPath, (ResourceIdentifiers)this.m_resourceIdentifiers);
        return resolvedProfilePath != null && !resolvedProfilePath.equals(trimmedPath) ? resolvedProfilePath : profileStorePath;
    }

    protected boolean validateFilePath() {
        if (!super.validateFilePath()) {
            return false;
        }
        File file = new File(this.getFilePathText());
        String defaultExtension = ProfileFileExtension.getDefault();
        if (ProfileFileExtension.exists((String)defaultExtension) && !this.validateFileExtension(file, defaultExtension)) {
            return false;
        }
        return this.validateOverwriteExistingFile(file);
    }

    private boolean validateFileExtension(File file, String defaultExtension) {
        String fileName = file.getName();
        int lastIndex = fileName.lastIndexOf(EXT_SEPARATOR);
        if (lastIndex >= 0 && fileName.length() > lastIndex + 1) {
            return true;
        }
        String[] dialogLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ui_errorLabel, null, Messages.bind((String)Messages.profileStoreCreationDialog_fileext_error, (Object)defaultExtension), 1, dialogLabels, 0);
        int response = dialog.open();
        if (response != 0) {
            return false;
        }
        String userFilePathText = super.getFilePathText();
        StringBuilder revisedFilePathText = new StringBuilder(userFilePathText);
        if (!userFilePathText.endsWith(EXT_SEPARATOR)) {
            revisedFilePathText.append(EXT_SEPARATOR);
        }
        revisedFilePathText.append(defaultExtension);
        super.setFilePathText(revisedFilePathText.toString());
        return false;
    }

    private boolean validateOverwriteExistingFile(File file) {
        if (!file.exists()) {
            return true;
        }
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ui_saveAsTitle, (String)Messages.bind((String)Messages.ui_replaceFilePrompt, (Object)file));
    }

    public void setProfileStorePath(String path, boolean isRelative) {
        this.m_isProfileStorePathRelative = isRelative;
        super.setFilePathText(path);
    }

    public void browseSelected() {
        this.m_browseButton.getMenuButtonProvider().setProperty("StoredPath", this.getFilePathText());
    }

    public boolean isProfileStorePathRelative() {
        return this.m_isProfileStorePathRelative;
    }
}

