/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SessionStatus implements Enumerator
{
    OK_LITERAL(0, "Ok", "Ok"),
    USER_CANCELLED_LITERAL(1, "UserCancelled", "UserCancelled"),
    LOGIN_FAILED_LITERAL(2, "LoginFailed", "LoginFailed"),
    ERROR_LITERAL(3, "Error", "Error");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int OK = 0;
    public static final int USER_CANCELLED = 1;
    public static final int LOGIN_FAILED = 2;
    public static final int ERROR = 3;
    private static final SessionStatus[] VALUES_ARRAY;
    public static final List<SessionStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SessionStatus[]{OK_LITERAL, USER_CANCELLED_LITERAL, LOGIN_FAILED_LITERAL, ERROR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SessionStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SessionStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SessionStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SessionStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SessionStatus get(int value) {
        switch (value) {
            case 0: {
                return OK_LITERAL;
            }
            case 1: {
                return USER_CANCELLED_LITERAL;
            }
            case 2: {
                return LOGIN_FAILED_LITERAL;
            }
            case 3: {
                return ERROR_LITERAL;
            }
        }
        return null;
    }

    private SessionStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

