/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.insert;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertTableElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class RemoveInsertColumnAction
extends Action {
    TableViewer gridViewer;

    public RemoveInsertColumnAction(TableViewer gridViewer) {
        super(Messages._UI_ACTION_REMOVE_COLUMN);
        this.gridViewer = gridViewer;
    }

    public void run() {
        ISelection selection = this.gridViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection es = (IStructuredSelection)selection;
        Iterator elements = es.iterator();
        this.gridViewer.cancelEditing();
        while (elements.hasNext()) {
            Object item = elements.next();
            if (!(item instanceof InsertTableElement)) continue;
            this.removeColumn((InsertTableElement)item);
        }
    }

    private void removeColumn(InsertTableElement insertElement) {
        QueryInsertStatement insertStmt = insertElement.getInsertStatement();
        EList columnList = insertStmt.getTargetColumnList();
        if (columnList != null) {
            ValueExpressionColumn col = insertElement.getColumn();
            InsertHelper.removeColumn(insertStmt, col);
        }
    }
}

