/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.insert;

import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.XMLDataType;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.Modifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertGridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertTableElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.RemoveInsertColumnAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;

public class InsertGridViewer
extends GridViewer {
    TableColumn c2;
    SQLDomainModel domainModel;
    DynamicComboBoxCellEditor insertValueCellEditor;

    public InsertGridViewer(SQLDomainModel domainModel, Composite parent) {
        super(domainModel, parent);
        this.domainModel = domainModel;
        WorkbenchHelp.setHelp((Control)this.table, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_INSERT_VALUE);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        this.table.setLayout((Layout)layout);
        String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_COLUMN, (String)SQLBuilderConstants.P_STATEMENT_VALUE};
        this.setColumnProperties(columnProperties);
        this.insertValueCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        CellEditor[] editors = new CellEditor[]{this.columnComboBoxCellEditor, this.insertValueCellEditor};
        this.setCellEditors(editors);
        this.setCellModifier(new Modifier());
        InsertGridContentProvider gridContentProvider = new InsertGridContentProvider(domainModel);
        this.setContentProvider((IContentProvider)gridContentProvider);
        InsertGridLabelProvider insertGridLabelProvider = new InsertGridLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)insertGridLabelProvider);
    }

    public SQLDomainModel getDomainModel() {
        return this.domainModel;
    }

    public void menuAboutToShow(IMenuManager menu) {
        RemoveInsertColumnAction removeColumnAction = new RemoveInsertColumnAction(this);
        menu.add((IAction)removeColumnAction);
    }

    @Override
    public void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.setGridTitle();
    }

    private void setGridTitle() {
    }

    public void refreshCellEditor(int row) {
        Object obj = this.getElementAt(row);
        int numOfItems = 2;
        if (this.domainModel.getVendor().isDB2()) {
            numOfItems = 3;
        }
        LabelValuePair[] valueComboItems = new LabelValuePair[numOfItems];
        if (this.domainModel.getVendor().isDB2()) {
            valueComboItems[0] = new LabelValuePair("DEFAULT", "DEFAULT");
            valueComboItems[1] = new LabelValuePair("NULL", "NULL");
            valueComboItems[2] = new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION);
        } else {
            valueComboItems[0] = new LabelValuePair("NULL", "NULL");
            valueComboItems[1] = new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION);
        }
        this.insertValueCellEditor.createItems(valueComboItems);
        this.insertValueCellEditor.setNeedQuotes(false);
        if (obj instanceof InsertTableElement) {
            QueryValueExpression expr = ((InsertTableElement)obj).getExpression();
            InsertTableElement insTE = (InsertTableElement)obj;
            ValueExpressionColumn colExpr = insTE.getColumn();
            if (expr != null) {
                int numOfItems2 = 3;
                if (this.domainModel.getVendor().isDB2()) {
                    numOfItems2 = colExpr != null && (colExpr.getDataType() instanceof XMLDataType || colExpr.getDataType() instanceof CharacterStringDataType) ? 5 : 4;
                }
                LabelValuePair[] valueComboItems2 = new LabelValuePair[numOfItems2];
                if (this.domainModel.getVendor().isDB2()) {
                    valueComboItems2[0] = new LabelValuePair("DEFAULT", "DEFAULT");
                    valueComboItems2[1] = new LabelValuePair("NULL", "NULL");
                    valueComboItems2[2] = new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION);
                    valueComboItems2[3] = new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION);
                    if (colExpr != null && (colExpr.getDataType() instanceof XMLDataType || colExpr.getDataType() instanceof CharacterStringDataType)) {
                        valueComboItems2[4] = new LabelValuePair(SQLBuilderConstants.P_EDIT_INPUT_VALUE, SQLBuilderConstants.P_EDIT_INPUT_VALUE);
                    }
                } else {
                    valueComboItems2[0] = new LabelValuePair("NULL", "NULL");
                    valueComboItems2[1] = new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION);
                    valueComboItems2[2] = new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION);
                }
                this.insertValueCellEditor.createItems(valueComboItems2);
            }
            if (colExpr != null) {
                this.insertValueCellEditor.setNeedQuotes(true);
                this.insertValueCellEditor.setQuotesContext("insert");
                this.insertValueCellEditor.setPairDataType(colExpr.getDataType());
            } else {
                this.insertValueCellEditor.setNeedQuotes(false);
            }
        }
        CellEditor[] editors = new CellEditor[]{this.columnComboBoxCellEditor, this.insertValueCellEditor};
        this.setCellEditors(editors);
    }

    public void setEnabled(boolean enable) {
        this.table.setEnabled(enable);
    }

    class InsertGridLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        InsertGridLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof InsertTableElement) {
                InsertTableElement insertElement = (InsertTableElement)object;
                return insertElement.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

