/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EModelElementItemProvider;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGenericTypeItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public EGenericTypeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addERawTypePropertyDescriptor(object);
            this.addETypeParameterPropertyDescriptor(object);
            this.addEClassifierPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addERawTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EGenericType_eRawType_feature"), this.getString("_UI_EGenericType_eRawType_description"), (EStructuralFeature)EcorePackage.Literals.EGENERIC_TYPE__ERAW_TYPE, false, false, true, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addETypeParameterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EModelElementItemProvider.ItemPropertyDescriptorWithUniqueChoiceOfValueLabels((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EGenericType_eTypeParameter_feature"), this.getString("_UI_EGenericType_eTypeParameter_description"), (EStructuralFeature)EcorePackage.Literals.EGENERIC_TYPE__ETYPE_PARAMETER, true, false, true, null, null, null){

            public boolean canSetProperty(Object object) {
                return super.canSetProperty(object) && !(((EGenericType)object).eContainer() instanceof EClass);
            }

            @Override
            public Collection<?> getChoiceOfValues(Object object) {
                ArrayList result = new ArrayList();
                result.add(null);
                EObject eObject = (EObject)object;
                while (eObject != null) {
                    if (eObject instanceof EClassifier) {
                        result.addAll(((EClassifier)eObject).getETypeParameters());
                    } else if (eObject instanceof EOperation) {
                        result.addAll(((EOperation)eObject).getETypeParameters());
                    }
                    result.remove(eObject);
                    eObject = eObject.eContainer();
                }
                this.uniqueNameMap = this.computeUniqueLabels(object, result);
                return result;
            }

            public void setPropertyValue(final Object object, Object value) {
                EditingDomain editingDomain = this.getEditingDomain(object);
                if (editingDomain == null) {
                    super.setPropertyValue(object, value);
                } else {
                    CompoundCommand command = new CompoundCommand(){

                        public Collection<?> getAffectedObjects() {
                            return Collections.singleton(object);
                        }
                    };
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS, (Object)Collections.EMPTY_LIST));
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ECLASSIFIER, null));
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND, null));
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND, null));
                    command.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ETYPE_PARAMETER, (Object)value));
                    editingDomain.getCommandStack().execute((Command)command);
                }
            }
        });
    }

    protected void addEClassifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EModelElementItemProvider.ItemPropertyDescriptorWithUniqueChoiceOfValueLabels((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EGenericType_eClassifier_feature"), this.getString("_UI_EGenericType_eClassifier_description"), (EStructuralFeature)EcorePackage.Literals.EGENERIC_TYPE__ECLASSIFIER, true, false, true, null, null, null){

            @Override
            public Collection<?> getChoiceOfValues(Object object) {
                Iterator i;
                EGenericType eGenericType = (EGenericType)object;
                ArrayList result = new ArrayList(super.getChoiceOfValues(object));
                EObject container = eGenericType.eContainer();
                if (!(container instanceof EReference)) {
                    for (Object classifier : EcorePackage.eINSTANCE.getEClassifiers()) {
                        if (result.contains(classifier)) continue;
                        result.add(classifier);
                    }
                }
                if (!result.contains(EcorePackage.Literals.EOBJECT)) {
                    result.add(EcorePackage.Literals.EOBJECT);
                }
                if (container instanceof EAttribute) {
                    i = result.iterator();
                    while (i.hasNext()) {
                        if (!(i.next() instanceof EClass)) continue;
                        i.remove();
                    }
                } else if (container instanceof EReference) {
                    i = result.iterator();
                    while (i.hasNext()) {
                        if (!(i.next() instanceof EDataType)) continue;
                        i.remove();
                    }
                } else if (container instanceof EClass) {
                    i = result.iterator();
                    while (i.hasNext()) {
                        Object choice = i.next();
                        if (!(choice instanceof EDataType) && choice != container && (choice == null || !((EClass)choice).getEAllSuperTypes().contains((Object)container))) continue;
                        i.remove();
                    }
                    for (EGenericType eGenericSuperType : ((EClass)container).getEGenericSuperTypes()) {
                        EClassifier eClassifier = eGenericSuperType.getERawType();
                        if (eClassifier == null) continue;
                        result.remove(eClassifier);
                    }
                } else if (container instanceof EOperation && eGenericType.eContainmentFeature() == EcorePackage.Literals.EOPERATION__EGENERIC_EXCEPTIONS) {
                    for (EGenericType eGenericException : ((EOperation)container).getEGenericExceptions()) {
                        EClassifier eClassifier = eGenericException.getERawType();
                        if (eClassifier == null) continue;
                        result.remove(eClassifier);
                    }
                }
                this.uniqueNameMap = this.computeUniqueLabels(object, result);
                return result;
            }

            public void setPropertyValue(final Object object, Object value) {
                EditingDomain editingDomain = this.getEditingDomain(object);
                if (editingDomain == null) {
                    super.setPropertyValue(object, value);
                } else {
                    CompoundCommand command = new CompoundCommand(){

                        public Collection<?> getAffectedObjects() {
                            return Collections.singleton(object);
                        }
                    };
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ETYPE_PARAMETER, null));
                    int typeParameterCount = value == null ? 0 : ((EClassifier)value).getETypeParameters().size();
                    ArrayList<EGenericType> typeArguments = new ArrayList<EGenericType>((Collection<EGenericType>)((EGenericType)object).getETypeArguments());
                    while (typeArguments.size() > typeParameterCount) {
                        typeArguments.remove(typeParameterCount);
                    }
                    while (typeArguments.size() < typeParameterCount) {
                        typeArguments.add(EcoreFactory.eINSTANCE.createEGenericType());
                    }
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS, typeArguments));
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND, null));
                    command.appendIfCanExecute(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND, null));
                    command.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)EcorePackage.Literals.EGENERIC_TYPE__ECLASSIFIER, (Object)value));
                    editingDomain.getCommandStack().execute((Command)command);
                }
            }
        });
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND);
            this.childrenFeatures.add(EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS);
            this.childrenFeatures.add(EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        EObject eObject;
        EGenericType eGenericType = (EGenericType)object;
        if (child instanceof EObject && (eObject = (EObject)child).eContainer() == eGenericType) {
            return eObject.eContainingFeature();
        }
        if (eGenericType.getEClassifier() != null) {
            return eGenericType.getETypeArguments().size() < eGenericType.getEClassifier().getETypeParameters().size() ? EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS : null;
        }
        if (eGenericType.getETypeParameter() != null) {
            return null;
        }
        if (eGenericType.eContainer() instanceof EGenericType) {
            return eGenericType.getELowerBound() != null ? EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND : EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND;
        }
        return null;
    }

    public Object getImage(Object object) {
        EGenericType eGenericType = (EGenericType)object;
        EReference eContainmentFeature = eGenericType.eContainmentFeature();
        return this.overlayImage(object, this.getResourceLocator().getImage(eContainmentFeature == EcorePackage.Literals.ECLASS__EGENERIC_SUPER_TYPES ? "full/obj16/EGenericSuperType" : (eContainmentFeature == EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE ? "full/obj16/EGenericElementType" : (eContainmentFeature == EcorePackage.Literals.EOPERATION__EGENERIC_EXCEPTIONS ? "full/obj16/EGenericException" : (eContainmentFeature == EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS ? "full/obj16/EGenericTypeArgument" : (eContainmentFeature == EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND || eContainmentFeature == EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND ? "full/obj16/EGenericWildcard" : "full/obj16/EGenericType"))))));
    }

    public String getText(Object object) {
        EGenericType eGenericType = (EGenericType)object;
        return EGenericTypeItemProvider.getText(eGenericType);
    }

    static String getText(EGenericType eGenericType) {
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            String name = eTypeParameter.getName();
            return name == null ? "null" : name;
        }
        EClassifier eClassifier = eGenericType.getEClassifier();
        if (eClassifier != null) {
            EList eTypeArguments = eGenericType.getETypeArguments();
            if (eTypeArguments.isEmpty()) {
                String name = eClassifier.getName();
                return name == null ? "null" : name;
            }
            StringBuilder result = new StringBuilder();
            result.append(eClassifier.getName());
            result.append('<');
            Iterator i = eTypeArguments.iterator();
            while (true) {
                result.append(EGenericTypeItemProvider.getText((EGenericType)i.next()));
                if (!i.hasNext()) break;
                result.append(", ");
            }
            result.append('>');
            return result.toString();
        }
        EGenericType eUpperBound = eGenericType.getEUpperBound();
        if (eUpperBound != null) {
            return "? extends " + EGenericTypeItemProvider.getText(eUpperBound);
        }
        EGenericType eLowerBound = eGenericType.getELowerBound();
        if (eLowerBound != null) {
            return "? super " + EGenericTypeItemProvider.getText(eLowerBound);
        }
        return "?";
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(EGenericType.class)) {
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                EObject container = ((EObject)notification.getNotifier()).eContainer();
                while (container != null) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)container, false, true));
                    if (container instanceof EOperation || container instanceof EStructuralFeature || container instanceof EClassifier) break;
                    container = container.eContainer();
                }
                return;
            }
            case 0: 
            case 1: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                EObject container = ((EObject)notification.getNotifier()).eContainer();
                while (container != null) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)container, false, true));
                    if (container instanceof EOperation || container instanceof EStructuralFeature || container instanceof EClassifier) break;
                    container = container.eContainer();
                }
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        EGenericType eGenericType = (EGenericType)object;
        if (eGenericType.eContainmentFeature() == EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS && eGenericType.getEClassifier() == null && eGenericType.getETypeParameter() == null) {
            newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND, EcoreFactory.eINSTANCE.createEGenericType()));
            newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND, EcoreFactory.eINSTANCE.createEGenericType()));
        }
        if (eGenericType.getEClassifier() != null && !eGenericType.getEClassifier().getETypeParameters().isEmpty()) {
            newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS, EcoreFactory.eINSTANCE.createEGenericType()));
        }
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        return feature == EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS ? this.getString("_UI_EGenericTypeArgument_label") : (feature == EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND ? this.getString("_UI_EGenericUpperBoundType_label") : (feature == EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND ? this.getString("_UI_EGenericLowerBoundType_label") : super.getCreateChildText(owner, feature, child, selection)));
    }

    public ResourceLocator getResourceLocator() {
        return EcoreEditPlugin.INSTANCE;
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        return new CreateChildCommand(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this){

            protected Command createCommand() {
                EGenericType eGenericType;
                if (!(this.feature != EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND && this.feature != EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND || (eGenericType = (EGenericType)this.owner).getELowerBound() == null && eGenericType.getEUpperBound() == null)) {
                    return UnexecutableCommand.INSTANCE;
                }
                return super.createCommand();
            }
        };
    }
}

