/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.ValueOfRatherThanInstantiationFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class ValueOfRatherThanInstantiationCleanUpCore
extends AbstractCleanUpCore {
    public ValueOfRatherThanInstantiationCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public ValueOfRatherThanInstantiationCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.valueof_rather_than_instantiation");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.valueof_rather_than_instantiation")) {
            return null;
        }
        return ValueOfRatherThanInstantiationFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.valueof_rather_than_instantiation")) {
            result.add(MultiFixMessages.ValueOfRatherThanInstantiationCleanup_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.valueof_rather_than_instantiation")) {
            return "Object characterObject = Character.valueOf('a');\nByte.valueOf(\"0\").byteValue();\nlong l = 42;\n";
        }
        return "Object characterObject = Character.valueOf('a');\nnew Byte(\"0\").byteValue();\nlong l = new Long(42);\n";
    }
}

