/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.callhierarchy.IImplementorFinder;
import org.eclipse.jdt.internal.corext.callhierarchy.JavaImplementorFinder;

public class Implementors {
    private static IImplementorFinder[] IMPLEMENTOR_FINDERS = new IImplementorFinder[]{new JavaImplementorFinder()};
    private static Implementors fgInstance;

    public static Implementors getInstance() {
        if (fgInstance == null) {
            fgInstance = new Implementors();
        }
        return fgInstance;
    }

    public IJavaElement[] searchForImplementors(IJavaElement[] elements, IProgressMonitor progressMonitor) {
        if (elements != null && elements.length > 0) {
            IJavaElement element = elements[0];
            try {
                IMember member;
                IType type;
                if (element instanceof IMember && (type = (member = (IMember)element).getDeclaringType()).isInterface()) {
                    IType[] implementingTypes = this.findImplementingTypes(type, progressMonitor);
                    if (member.getElementType() == 9) {
                        return this.findMethods((IMethod)member, implementingTypes, progressMonitor);
                    }
                    return implementingTypes;
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return null;
    }

    public IJavaElement[] searchForInterfaces(IJavaElement[] elements, IProgressMonitor progressMonitor) {
        IJavaElement element;
        if (elements != null && elements.length > 0 && (element = elements[0]) instanceof IMember) {
            IMember member = (IMember)element;
            IType type = member.getDeclaringType();
            IType[] implementingTypes = this.findInterfaces(type, progressMonitor);
            if (!progressMonitor.isCanceled()) {
                if (member.getElementType() == 9) {
                    return this.findMethods((IMethod)member, implementingTypes, progressMonitor);
                }
                return implementingTypes;
            }
        }
        return null;
    }

    private IImplementorFinder[] getImplementorFinders() {
        return IMPLEMENTOR_FINDERS;
    }

    private IType[] findImplementingTypes(IType type, IProgressMonitor progressMonitor) {
        ArrayList<IType> implementingTypes = new ArrayList<IType>();
        IImplementorFinder[] finders = this.getImplementorFinders();
        int i = 0;
        while (i < finders.length && !progressMonitor.isCanceled()) {
            Collection<IType> types = finders[i].findImplementingTypes(type, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10, 2));
            if (types != null) {
                implementingTypes.addAll(types);
            }
            ++i;
        }
        return implementingTypes.toArray(new IType[implementingTypes.size()]);
    }

    private IType[] findInterfaces(IType type, IProgressMonitor progressMonitor) {
        ArrayList<IType> interfaces = new ArrayList<IType>();
        IImplementorFinder[] finders = this.getImplementorFinders();
        int i = 0;
        while (i < finders.length && !progressMonitor.isCanceled()) {
            Collection<IType> types = finders[i].findInterfaces(type, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10, 2));
            if (types != null) {
                interfaces.addAll(types);
            }
            ++i;
        }
        return interfaces.toArray(new IType[interfaces.size()]);
    }

    private IJavaElement[] findMethods(IMethod method, IType[] types, IProgressMonitor progressMonitor) {
        ArrayList<IMethod> foundMethods = new ArrayList<IMethod>();
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 10, 2);
        subProgressMonitor.beginTask("", types.length);
        try {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                IMethod[] methods = type.findMethods(method);
                if (methods != null) {
                    foundMethods.addAll(Arrays.asList(methods));
                }
                subProgressMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            subProgressMonitor.done();
        }
        return foundMethods.toArray(new IJavaElement[foundMethods.size()]);
    }
}

