/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.category.SiteCategoryDefinitionAdapter;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CategoryDetailsSection
extends PDESection
implements IPartSelectionListener {
    private static final String PROPERTY_DESC = "desc";
    private static final String PROPERTY_NAME = "url";
    private static final String PROPERTY_TYPE = "type";
    private ISiteCategoryDefinition fCurrentCategoryDefinition;
    private FormEntry fDescriptionText;
    private FormEntry fLabelText;
    private FormEntry fNameText;

    public CategoryDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.CategoryDetails_title, PDEUIMessages.CategoryDetails_sectionDescription, 0);
    }

    public CategoryDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private boolean alreadyExists(String name) {
        ISiteCategoryDefinition[] defs;
        ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = defs = this.fCurrentCategoryDefinition.getModel().getSite().getCategoryDefinitions();
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            String dname;
            ISiteCategoryDefinition def = iSiteCategoryDefinitionArray[n2];
            if (def != this.fCurrentCategoryDefinition && (dname = def.getName()) != null && dname.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void applyValue(String property, String value) throws CoreException {
        if (this.fCurrentCategoryDefinition == null) {
            return;
        }
        switch (property) {
            case "url": {
                String oldName = this.fCurrentCategoryDefinition.getName();
                this.fCurrentCategoryDefinition.setName(value);
                this.updateBundlesAndFeatures(oldName);
                break;
            }
            case "type": {
                this.fCurrentCategoryDefinition.setLabel(value);
                break;
            }
            case "desc": {
                if (value == null || value.length() == 0) {
                    this.fCurrentCategoryDefinition.setDescription(null);
                    break;
                }
                ISiteDescription siteDesc = this.fCurrentCategoryDefinition.getDescription();
                if (siteDesc == null) {
                    siteDesc = this.fCurrentCategoryDefinition.getModel().getFactory().createDescription((ISiteObject)this.fCurrentCategoryDefinition);
                    siteDesc.setText(value);
                    this.fCurrentCategoryDefinition.setDescription(siteDesc);
                    break;
                }
                siteDesc.setText(value);
                break;
            }
        }
    }

    @Override
    public void cancelEdit() {
        this.fNameText.cancelEdit();
        this.fLabelText.cancelEdit();
        this.fDescriptionText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        TransferData[] transferDataArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData type = transferDataArray[n2];
            Transfer[] transferArray = transfers;
            int n3 = transfers.length;
            int n4 = 0;
            while (n4 < n3) {
                Transfer transfer = transferArray[n4];
                if (transfer.isSupportedType(type)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private void clearField(String property) {
        switch (property) {
            case "url": {
                this.fNameText.setValue(null, true);
                break;
            }
            case "type": {
                this.fLabelText.setValue(null, true);
                break;
            }
            case "desc": {
                this.fDescriptionText.setValue(null, true);
                break;
            }
        }
    }

    private void clearFields() {
        this.fNameText.setValue(null, true);
        this.fLabelText.setValue(null, true);
        this.fDescriptionText.setValue(null, true);
    }

    public void commit(boolean onSave) {
        this.fNameText.commit();
        this.fLabelText.commit();
        this.fDescriptionText.commit();
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.CategoryDetails_name, null, false);
        this.fNameText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    if (text.getValue().length() <= 0 || CategoryDetailsSection.this.alreadyExists(text.getValue())) {
                        CategoryDetailsSection.this.setValue(CategoryDetailsSection.PROPERTY_NAME);
                        String message = PDEUIMessages.CategoryDetails_alreadyExists;
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.CategoryDetails_alreadyExists_title, (String)message);
                    } else {
                        CategoryDetailsSection.this.applyValue(CategoryDetailsSection.PROPERTY_NAME, text.getValue());
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fNameText);
        this.fNameText.setEditable(this.isEditable());
        this.fLabelText = new FormEntry(container, toolkit, PDEUIMessages.CategoryDetails_label, null, false);
        this.fLabelText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    CategoryDetailsSection.this.applyValue(CategoryDetailsSection.PROPERTY_TYPE, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fLabelText);
        this.fLabelText.setEditable(this.isEditable());
        this.fDescriptionText = new FormEntry(container, toolkit, PDEUIMessages.CategoryDetails_desc, 66);
        this.fDescriptionText.getText().setLayoutData((Object)new GridData(1808));
        this.fDescriptionText.getLabel().setLayoutData((Object)new GridData(2));
        this.fDescriptionText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    CategoryDetailsSection.this.applyValue(CategoryDetailsSection.PROPERTY_DESC, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fDescriptionText);
        this.fDescriptionText.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    private void updateBundlesAndFeatures(String oldCategory) {
        ISiteCategoryDefinition[] categories;
        ISiteBundle[] siteBundles;
        int n;
        ISiteFeature[] siteFeatures;
        ISiteFeature[] iSiteFeatureArray = siteFeatures = this.fCurrentCategoryDefinition.getModel().getSite().getFeatures();
        int n2 = siteFeatures.length;
        int n3 = 0;
        while (n3 < n2) {
            ISiteCategory[] categories2;
            ISiteFeature siteFeature = iSiteFeatureArray[n3];
            ISiteCategory[] iSiteCategoryArray = categories2 = siteFeature.getCategories();
            n = categories2.length;
            int n4 = 0;
            while (n4 < n) {
                ISiteCategory categorie = iSiteCategoryArray[n4];
                if (oldCategory.equals(categorie.getName())) {
                    try {
                        categorie.setName(this.fCurrentCategoryDefinition.getName());
                    }
                    catch (CoreException coreException) {}
                }
                ++n4;
            }
            ++n3;
        }
        ISiteBundle[] iSiteBundleArray = siteBundles = this.fCurrentCategoryDefinition.getModel().getSite().getBundles();
        int n5 = siteBundles.length;
        n2 = 0;
        while (n2 < n5) {
            ISiteCategory[] categories3;
            ISiteBundle siteBundle = iSiteBundleArray[n2];
            ISiteCategory[] iSiteCategoryArray = categories3 = siteBundle.getCategories();
            int n6 = categories3.length;
            n = 0;
            while (n < n6) {
                ISiteCategory categorie = iSiteCategoryArray[n];
                if (oldCategory.equals(categorie.getName())) {
                    try {
                        categorie.setName(this.fCurrentCategoryDefinition.getName());
                    }
                    catch (CoreException coreException) {}
                }
                ++n;
            }
            ++n2;
        }
        ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = categories = this.fCurrentCategoryDefinition.getSite().getCategoryDefinitions();
        int n7 = categories.length;
        n5 = 0;
        while (n5 < n7) {
            ISiteCategory[] cats;
            ISiteCategoryDefinition categorie = iSiteCategoryDefinitionArray[n5];
            ISiteCategory[] iSiteCategoryArray = cats = categorie.getCategories();
            int n8 = cats.length;
            int n9 = 0;
            while (n9 < n8) {
                ISiteCategory cat = iSiteCategoryArray[n9];
                if (cat.getParent() != null && oldCategory.equals(cat.getName())) {
                    try {
                        cat.setName(this.fCurrentCategoryDefinition.getName());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                ++n9;
            }
            ++n5;
        }
    }

    public void refresh() {
        if (this.fCurrentCategoryDefinition == null) {
            this.clearFields();
            super.refresh();
            return;
        }
        this.setValue(PROPERTY_NAME);
        this.setValue(PROPERTY_TYPE);
        this.setValue(PROPERTY_DESC);
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fCurrentCategoryDefinition = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof ISiteCategoryDefinition ? (ISiteCategoryDefinition)o : (o instanceof SiteCategoryDefinitionAdapter ? ((SiteCategoryDefinitionAdapter)o).category : null)) : null;
        this.refresh();
    }

    public void setFocus() {
        if (this.fNameText != null) {
            this.fNameText.getText().setFocus();
        }
    }

    private void setValue(String property) {
        block15: {
            block14: {
                if (this.fCurrentCategoryDefinition != null) break block14;
                this.clearField(property);
                break block15;
            }
            switch (property) {
                case "url": {
                    this.fNameText.setValue(this.fCurrentCategoryDefinition.getName(), true);
                    break;
                }
                case "type": {
                    this.fLabelText.setValue(this.fCurrentCategoryDefinition.getLabel(), true);
                    break;
                }
                case "desc": {
                    ISiteDescription siteDesc = this.fCurrentCategoryDefinition.getDescription();
                    if (siteDesc == null) {
                        this.clearField(property);
                        break;
                    }
                    this.fDescriptionText.setValue(siteDesc.getText(), true);
                    break;
                }
            }
        }
    }
}

