/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.restadapter.Event;
import org.eclipse.comma.project.generatortasks.restadapter.EventMatch;
import org.eclipse.comma.project.generatortasks.restadapter.SUTToCommaTrace;
import org.eclipse.comma.project.generatortasks.restadapter.VectorDescriptor;
import org.eclipse.comma.project.project.EventMapping;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.ParameterSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.PathMappings;
import org.eclipse.comma.project.project.SignatureMapping;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;

public class RESTTraceConverter {
    public static CharSequence convertTrace(InputStream is, Component component, PathMappings mappings) {
        StringBuilder result = new StringBuilder();
        HashMap<String, EventMatch> notifications = new HashMap<String, EventMatch>();
        boolean processingNotification = false;
        Command lastObservedCommand = null;
        Signal lastObservedSignal = null;
        String componentDeclaration = String.format("{\"components\" : [{\"type\":\"%s\",\"value\":\"c\"}]}", component.getName());
        result.append(componentDeclaration);
        result.append(System.lineSeparator());
        try {
            Throwable throwable = null;
            Object var10_13 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = br.readLine()) != null) {
                    JsonElement nonPathParamsJson;
                    JsonObject paramInJson;
                    EventMatch match;
                    String uri;
                    String[] subFragments;
                    if (processingNotification) {
                        processingNotification = false;
                        continue;
                    }
                    String[] fragments = line.split("\t+", 6);
                    if (fragments[5].startsWith("GET")) {
                        subFragments = fragments[5].split("\t+", 3);
                        uri = subFragments[1];
                        match = RESTTraceConverter.findEvent(uri, mappings);
                        if (match == null) continue;
                        if (match.event instanceof Notification) {
                            notifications.put(fragments[2], match);
                            processingNotification = true;
                            continue;
                        }
                        if (lastObservedCommand != null) continue;
                        Command command = (Command)match.event;
                        Signature sig = (Signature)match.event.eContainer();
                        Event event = new Event("Command", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), match.event.getName(), "client", "clientPort", "c", RESTTraceConverter.getPort(component, sig));
                        for (Parameter p2 : command.getParameters()) {
                            if (p2.getDirection() != DIRECTION.IN) continue;
                            paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), (JsonElement)new JsonPrimitive(match.bindings.get(p2.getName())));
                            event.addParameter(paramInJson);
                        }
                        lastObservedCommand = command;
                        result.append(event.toJson());
                        result.append(System.lineSeparator());
                        continue;
                    }
                    if (fragments[5].startsWith("PUT")) {
                        String kind;
                        subFragments = fragments[5].split("\t+", 3);
                        uri = subFragments[1];
                        match = RESTTraceConverter.findEvent(uri, mappings);
                        if (match == null || lastObservedCommand != null || lastObservedSignal != null) continue;
                        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(mappings, match.event);
                        List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(mappings, match.event);
                        nonPathParamsJson = null;
                        if (nonPathParameters.size() > 0) {
                            String[] subsubFragments = subFragments[2].split("\t+", 2);
                            nonPathParamsJson = JsonParser.parseString((String)subsubFragments[0]);
                        }
                        Signature sig = (Signature)match.event.eContainer();
                        if (match.event instanceof Signal) {
                            kind = "Signal";
                            lastObservedSignal = (Signal)match.event;
                        } else {
                            kind = "Command";
                            lastObservedCommand = (Command)match.event;
                        }
                        Event event = new Event(kind, RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), match.event.getName(), "client", "clientPort", "c", RESTTraceConverter.getPort(component, sig));
                        for (Parameter p3 : match.event.getParameters()) {
                            JsonObject paramInJson2;
                            if (pathParameters.contains(p3)) {
                                paramInJson2 = RESTTraceConverter.convertToCommaJson(p3.getType(), (JsonElement)new JsonPrimitive(match.bindings.get(p3.getName())));
                                event.addParameter(paramInJson2);
                                continue;
                            }
                            if (nonPathParameters.size() == 1) {
                                paramInJson2 = RESTTraceConverter.convertToCommaJson(p3.getType(), nonPathParamsJson);
                                event.addParameter(paramInJson2);
                                continue;
                            }
                            paramInJson2 = RESTTraceConverter.convertToCommaJson(p3.getType(), nonPathParamsJson.getAsJsonObject().get(p3.getName()));
                            event.addParameter(paramInJson2);
                        }
                        result.append(event.toJson());
                        result.append(System.lineSeparator());
                        continue;
                    }
                    if (notifications.containsKey(fragments[4])) {
                        Notification n = (Notification)((EventMatch)notifications.get((Object)fragments[4])).event;
                        Signature sig = (Signature)n.eContainer();
                        Event event = new Event("Notification", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), n.getName(), "c", RESTTraceConverter.getPort(component, sig), "client", "clientPort");
                        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(mappings, (InterfaceEvent)n);
                        List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(mappings, (InterfaceEvent)n);
                        nonPathParamsJson = null;
                        if (nonPathParameters.size() > 0) {
                            String nonPathParams = fragments[5].substring(11);
                            nonPathParamsJson = JsonParser.parseString((String)nonPathParams);
                        }
                        for (Parameter p2 : n.getParameters()) {
                            if (pathParameters.contains(p2)) {
                                paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), (JsonElement)new JsonPrimitive(((EventMatch)notifications.get((Object)fragments[4])).bindings.get(p2.getName())));
                                event.addParameter(paramInJson);
                                continue;
                            }
                            if (nonPathParameters.size() == 1) {
                                paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), nonPathParamsJson);
                                event.addParameter(paramInJson);
                                continue;
                            }
                            paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), nonPathParamsJson.getAsJsonObject().get(p2.getName()));
                            event.addParameter(paramInJson);
                        }
                        result.append(event.toJson());
                        result.append(System.lineSeparator());
                        continue;
                    }
                    if (lastObservedSignal != null) {
                        lastObservedSignal = null;
                        continue;
                    }
                    Signature sig = (Signature)lastObservedCommand.eContainer();
                    Event event = new Event("Reply", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), lastObservedCommand.getName(), "c", RESTTraceConverter.getPort(component, sig), "client", "clientPort");
                    List outParams = lastObservedCommand.getParameters().stream().filter(p -> p.getDirection() == DIRECTION.OUT).collect(Collectors.toList());
                    boolean isVoid = TypeUtilities.isVoid((Type)lastObservedCommand.getType());
                    int returnValuesSize = outParams.size();
                    if (!isVoid) {
                        ++returnValuesSize;
                    }
                    JsonElement paramsJson = null;
                    if (returnValuesSize > 0) {
                        String params = fragments[5].split("\t+", 2)[0];
                        paramsJson = JsonParser.parseString((String)params);
                    }
                    for (Parameter p2 : outParams) {
                        if (returnValuesSize == 1) {
                            paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), paramsJson);
                            event.addParameter(paramInJson);
                            continue;
                        }
                        paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), paramsJson.getAsJsonObject().get(p2.getName()));
                        event.addParameter(paramInJson);
                    }
                    if (!isVoid) {
                        JsonObject paramInJson3;
                        if (returnValuesSize == 1) {
                            paramInJson3 = RESTTraceConverter.convertToCommaJson(lastObservedCommand.getType(), paramsJson);
                            event.addParameter(paramInJson3);
                        } else {
                            paramInJson3 = RESTTraceConverter.convertToCommaJson(lastObservedCommand.getType(), paramsJson.getAsJsonObject().get("result"));
                            event.addParameter(paramInJson3);
                        }
                    }
                    result.append(event.toJson());
                    result.append(System.lineSeparator());
                    lastObservedCommand = null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private static JsonObject convertToCommaJson(Type type, JsonElement value) {
        if (type instanceof TypeReference) {
            TypeDecl typeDecl = ((TypeReference)type).getType();
            if (typeDecl instanceof SimpleTypeDecl) {
                if (((SimpleTypeDecl)typeDecl).getBase() != null) {
                    typeDecl = ((SimpleTypeDecl)typeDecl).getBase();
                }
                if (typeDecl.getName().equals("int")) {
                    return SUTToCommaTrace.convertInt(value);
                }
                if (typeDecl.getName().equals("string")) {
                    return SUTToCommaTrace.convertString(value);
                }
                if (typeDecl.getName().equals("real")) {
                    return SUTToCommaTrace.convertReal(value);
                }
                if (typeDecl.getName().equals("bool")) {
                    return SUTToCommaTrace.convertBool(value);
                }
            }
            if (typeDecl instanceof EnumTypeDecl) {
                return SUTToCommaTrace.convertEnum(typeDecl.getName(), value);
            }
            if (typeDecl instanceof RecordTypeDecl) {
                return SUTToCommaTrace.convertRecord((RecordTypeDecl)typeDecl, value);
            }
            if (typeDecl instanceof VectorTypeDecl) {
                VectorDescriptor descr = VectorDescriptor.getDescriptor(((VectorTypeDecl)typeDecl).getConstructor());
                SUTToCommaTrace.convertVector(descr.elementType, descr.dimensions, value);
            }
        }
        if (type instanceof VectorTypeConstructor) {
            VectorDescriptor descr = VectorDescriptor.getDescriptor((VectorTypeConstructor)type);
            return SUTToCommaTrace.convertVector(descr.elementType, descr.dimensions, value);
        }
        return null;
    }

    private static EventMatch findEvent(String uri, PathMappings mappings) {
        EventMatch result = null;
        for (SignatureMapping sigMapping : mappings.getSignatureMappings()) {
            for (EventMapping eventMapping : sigMapping.getEventMappings()) {
                result = RESTTraceConverter.matchPath(eventMapping.getPath(), uri);
                if (result == null) continue;
                result.event = eventMapping.getEvent();
                return result;
            }
        }
        return result;
    }

    private static EventMatch matchPath(Path path, String uri) {
        String[] uriFragments = uri.split("/");
        if (uriFragments.length - 1 != path.getSegments().size()) {
            return null;
        }
        HashMap<String, String> bindings = new HashMap<String, String>();
        int i = 0;
        while (i < path.getSegments().size()) {
            String segment;
            if (path.getSegments().get(i) instanceof FixedSegment) {
                segment = ((FixedSegment)path.getSegments().get(i)).getName();
                if (!segment.equals(uriFragments[i + 1])) {
                    return null;
                }
            } else {
                segment = ((ParameterSegment)path.getSegments().get(i)).getParameter().getName();
                bindings.put(segment, uriFragments[i + 1]);
            }
            ++i;
        }
        EventMatch result = new EventMatch();
        result.bindings = bindings;
        return result;
    }

    private static String convertTimestamp(String epochTime) {
        Double epochTimeDouble = Double.valueOf(epochTime);
        Long timeInMillis = (long)(epochTimeDouble * 1000.0);
        Instant epochTimeInstant = Instant.ofEpochMilli(timeInMillis);
        OffsetDateTime odt = OffsetDateTime.ofInstant(epochTimeInstant, ZoneId.of("Europe/Paris"));
        return odt.toString();
    }

    private static String getPort(Component component, Signature sig) {
        for (Port port : component.getPorts()) {
            if (!(port instanceof ProvidedPort) || port.getInterface() != sig) continue;
            return port.getName();
        }
        return "";
    }
}

