/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.ui.launchview.internal.LaunchViewMessages;
import org.eclipse.osgi.util.NLS;

public class FileLogger
implements IStreamListener,
Closeable {
    private final BufferedWriter writer;

    public FileLogger(File file) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        try {
            this.writer.write(text);
            this.writer.flush();
        }
        catch (Exception ex) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)LaunchViewMessages.FileLogger_FailedAppend, (Object)text), (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

