/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfBitmap16;
import org.apache.poi.hwmf.record.HwmfBitmapDib;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfDraw;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.hwmf.record.HwmfTernaryRasterOp;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfFill {
    static int readBounds2(LittleEndianInputStream leis, Rectangle2D bounds) {
        short h = leis.readShort();
        short w = leis.readShort();
        short y = leis.readShort();
        short x = leis.readShort();
        bounds.setRect(x, y, w, h);
        return 8;
    }

    public static class WmfDibStretchBlt
    implements HwmfRecord,
    HwmfImageRecord,
    HwmfObjectTableEntry {
        protected HwmfTernaryRasterOp rasterOperation;
        protected final Rectangle2D srcBounds = new Rectangle2D.Double();
        protected final Rectangle2D dstBounds = new Rectangle2D.Double();
        protected HwmfBitmapDib target;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.dibStretchBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize > (long)((recordFunction >> 8) + 3);
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            int size = 4;
            size += HwmfFill.readBounds2(leis, this.srcBounds);
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            size += HwmfFill.readBounds2(leis, this.dstBounds);
            if (hasBitmap) {
                this.target = new HwmfBitmapDib();
                size += this.target.init(leis, (int)(recordSize - 6L - (long)size));
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }

        @Override
        public BufferedImage getImage() {
            return this.target != null && this.target.isValid() ? this.target.getImage() : null;
        }
    }

    public static class WmfDibBitBlt
    extends WmfDibStretchBlt {
        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.dibBitBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize / 2L != (long)((recordFunction >> 8) + 3);
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            int size = 4;
            Point2D.Double srcPnt = new Point2D.Double();
            size += HwmfDraw.readPointS(leis, srcPnt);
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            size += HwmfFill.readBounds2(leis, this.dstBounds);
            if (hasBitmap) {
                this.target = new HwmfBitmapDib();
                size += this.target.init(leis, (int)(recordSize - 6L - (long)size));
            }
            this.srcBounds.setRect(((Point2D)srcPnt).getX(), ((Point2D)srcPnt).getY(), this.dstBounds.getWidth(), this.dstBounds.getHeight());
            return size;
        }
    }

    public static class WmfSetDibToDev
    implements HwmfRecord,
    HwmfImageRecord,
    HwmfObjectTableEntry {
        private ColorUsage colorUsage;
        private int scanCount;
        private int startScan;
        protected final Rectangle2D srcBounds = new Rectangle2D.Double();
        protected final Rectangle2D dstBounds = new Rectangle2D.Double();
        private HwmfBitmapDib dib;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setDibToDev;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.colorUsage = ColorUsage.valueOf(leis.readUShort());
            this.scanCount = leis.readUShort();
            this.startScan = leis.readUShort();
            int size = 6;
            Point2D.Double srcPnt = new Point2D.Double();
            size += HwmfDraw.readPointS(leis, srcPnt);
            size += HwmfFill.readBounds2(leis, this.dstBounds);
            this.dib = new HwmfBitmapDib();
            size += this.dib.init(leis, (int)(recordSize - 6L - (long)size));
            this.srcBounds.setRect(((Point2D)srcPnt).getX(), ((Point2D)srcPnt).getY(), this.dstBounds.getWidth(), this.dstBounds.getHeight());
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }

        @Override
        public BufferedImage getImage() {
            return this.dib.getImage();
        }
    }

    public static class WmfBitBlt
    extends WmfStretchBlt {
        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.bitBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize / 2L != (long)((recordFunction >> 8) + 3);
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            int size = 4;
            Point2D.Double srcPnt = new Point2D.Double();
            size += HwmfDraw.readPointS(leis, srcPnt);
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            size += HwmfFill.readBounds2(leis, this.dstBounds);
            if (hasBitmap) {
                this.target = new HwmfBitmap16();
                size += this.target.init(leis);
            }
            this.srcBounds.setRect(((Point2D)srcPnt).getX(), ((Point2D)srcPnt).getY(), this.dstBounds.getWidth(), this.dstBounds.getHeight());
            return size;
        }
    }

    public static class WmfStretchDib
    implements HwmfRecord,
    HwmfImageRecord {
        protected HwmfTernaryRasterOp rasterOperation;
        protected ColorUsage colorUsage;
        protected final Rectangle2D srcBounds = new Rectangle2D.Double();
        protected final Rectangle2D dstBounds = new Rectangle2D.Double();
        protected final HwmfBitmapDib bitmap = new HwmfBitmapDib();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.stretchDib;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.colorUsage = ColorUsage.valueOf(leis.readUShort());
            int size = 6;
            size += HwmfFill.readBounds2(leis, this.srcBounds);
            size += HwmfFill.readBounds2(leis, this.dstBounds);
            size += this.bitmap.init(leis, (int)(recordSize - 6L - (long)size));
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            HwmfDrawProperties prop = ctx.getProperties();
            prop.setRasterOp(this.rasterOperation);
            if (this.bitmap.isValid()) {
                ctx.drawImage(this.getImage(), this.srcBounds, this.dstBounds);
            } else if (!this.dstBounds.isEmpty()) {
                BufferedImage bi = new BufferedImage(100, 100, 2);
                ctx.drawImage(bi, new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0), this.dstBounds);
            }
        }

        @Override
        public BufferedImage getImage() {
            return this.bitmap.getImage();
        }

        public String toString() {
            return "{ rasterOperation: '" + (Object)((Object)this.rasterOperation) + "', colorUsage: '" + (Object)((Object)this.colorUsage) + "', srcBounds: " + HwmfDraw.boundsToString(this.srcBounds) + ", dstBounds: " + HwmfDraw.boundsToString(this.dstBounds) + "}";
        }
    }

    public static class WmfStretchBlt
    implements HwmfRecord {
        protected HwmfTernaryRasterOp rasterOperation;
        protected final Rectangle2D srcBounds = new Rectangle2D.Double();
        protected final Rectangle2D dstBounds = new Rectangle2D.Double();
        protected HwmfBitmap16 target;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.stretchBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize > (long)((recordFunction >> 8) + 3);
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            int size = 4;
            size += HwmfFill.readBounds2(leis, this.srcBounds);
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            size += HwmfFill.readBounds2(leis, this.dstBounds);
            if (hasBitmap) {
                this.target = new HwmfBitmap16();
                size += this.target.init(leis);
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }

        public String toString() {
            return "{ rasterOperation: '" + (Object)((Object)this.rasterOperation) + "', srcBounds: " + HwmfDraw.boundsToString(this.srcBounds) + ", dstBounds: " + HwmfDraw.boundsToString(this.dstBounds) + "}";
        }
    }

    public static class WmfPatBlt
    implements HwmfRecord {
        private HwmfTernaryRasterOp rasterOperation;
        private final Rectangle2D bounds = new Rectangle2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.patBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            return HwmfFill.readBounds2(leis, this.bounds) + 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfInvertRegion
    implements HwmfRecord {
        private int region;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.invertRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.region = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfExtFloodFill
    extends WmfFloodFill {
        protected int mode;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.extFloodFill;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.mode = leis.readUShort();
            return super.init(leis, recordSize, recordFunction) + 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetPolyfillMode
    implements HwmfRecord {
        protected HwmfPolyfillMode polyFillMode;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setPolyFillMode;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.polyFillMode = HwmfPolyfillMode.valueOf(leis.readUShort() & 3);
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setPolyfillMode(this.polyFillMode);
        }

        public String toString() {
            return "{ polyFillMode: '" + (Object)((Object)this.polyFillMode) + "' }";
        }

        public static enum HwmfPolyfillMode {
            ALTERNATE(1, 0),
            WINDING(2, 1);

            public final int wmfFlag;
            public final int awtFlag;

            private HwmfPolyfillMode(int wmfFlag, int awtFlag) {
                this.wmfFlag = wmfFlag;
                this.awtFlag = awtFlag;
            }

            public static HwmfPolyfillMode valueOf(int wmfFlag) {
                for (HwmfPolyfillMode pm : HwmfPolyfillMode.values()) {
                    if (pm.wmfFlag != wmfFlag) continue;
                    return pm;
                }
                return null;
            }
        }
    }

    public static class WmfFloodFill
    implements HwmfRecord {
        protected final HwmfColorRef colorRef = new HwmfColorRef();
        protected final Point2D start = new Point2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.floodFill;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int size = this.colorRef.init(leis);
            return size += HwmfDraw.readPointS(leis, this.start);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfPaintRegion
    implements HwmfRecord {
        int regionIndex;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.paintRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.regionIndex = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.regionIndex);
            Shape region = ctx.getProperties().getRegion();
            if (region != null) {
                ctx.fill(region);
            }
        }
    }

    public static class WmfFillRegion
    implements HwmfRecord {
        protected int regionIndex;
        protected int brushIndex;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.fillRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.regionIndex = leis.readUShort();
            this.brushIndex = leis.readUShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.regionIndex);
            ctx.applyObjectTableEntry(this.brushIndex);
            Shape region = ctx.getProperties().getRegion();
            if (region != null) {
                ctx.fill(region);
            }
        }
    }

    public static enum ColorUsage {
        DIB_RGB_COLORS(0),
        DIB_PAL_COLORS(1),
        DIB_PAL_INDICES(2);

        public final int flag;

        private ColorUsage(int flag) {
            this.flag = flag;
        }

        public static ColorUsage valueOf(int flag) {
            for (ColorUsage bs : ColorUsage.values()) {
                if (bs.flag != flag) continue;
                return bs;
            }
            return null;
        }
    }

    public static interface HwmfImageRecord {
        public BufferedImage getImage();
    }
}

